/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class TelescopeDevice
extends Device {
    public static final int CHAN_DOME_XMINUS_TEMP = 0;
    public static final int CHAN_DOME_YMINUS_TEMP = 1;
    public static final int NUM_CHANNELS = 2;
    private static final Logger LOG = Logger.getLogger(TelescopeDevice.class.getName());
    private final Map<String, Integer> channelMap = new LinkedHashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();

    protected void initDevice() {
        for (int chan = 0; chan < 2; ++chan) {
            this.channelValues.add(chan, 18.0);
        }
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 2) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hwChan", (Object)hwChan);
        }
        this.channelMap.put(ch.getName(), hwChan);
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        return this.channelValues.get(ch.getHwChan()) + 0.2 * (Math.random() - 0.5);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chName, @Argument(description="Channel value") double value) throws UtilityException {
        Integer index = this.channelMap.get(chName);
        if (index == null) {
            throw new UtilityException("Invalid channel name: " + chName);
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

