/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cornerstone;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cornerstone.C260;

public class TestC260 {
    protected C260 mydev;

    @Command(name="open", description="Open a device for use")
    public void open(@Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new C260();
        this.mydev.open(MyDevId);
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud") int baud) throws DriverException {
        this.mydev = new C260();
        this.mydev.openftdi(host, baud);
        return this.mydev.getInfo();
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="readident", description="Read info")
    public String readident() throws Exception {
        return this.mydev.getInfo();
    }

    @Command(name="testthreads", description="test")
    public void testthreads(double w) throws Exception {
        this.mydev.testThreads(w);
    }

    @Command(name="sethandshake", description="Set Handshake mode")
    public void sethandshake(@Argument(name="flag", description="1 to turn handshake mode on, 0 is off") int flag) throws Exception {
        this.mydev.setHandshake(flag);
    }

    @Command(name="sethandshakeon", description="Set Handshake mode on")
    public void sethandshakeon() throws Exception {
        this.mydev.setHandshakeOn();
    }

    @Command(name="sethandshakeoff", description="Set Handshake mode off")
    public void sethandshakeoff() throws Exception {
        this.mydev.setHandshakeOff();
    }

    @Command(name="gethandshake", description="Check Handshake returns true if handshake is on")
    public boolean gethandshake() throws Exception {
        return this.mydev.getHandshake();
    }

    @Command(name="getstatus", description="Returns Status byte, nonzero indicates an error condition")
    public int getstatus() throws Exception {
        return this.mydev.getStatus();
    }

    @Command(name="getfullerror", description="Returns most recent Error ")
    public int getfullerror() throws Exception {
        C260.storedError err = this.mydev.new C260.storedError();
        int errCode = this.mydev.getFullError(err);
        System.out.println("error: " + err.getCommand() + " " + err.getErrorCode());
        return err.getErrorCode();
    }

    @Command(name="geterror", description="returns current error code")
    public int geterror() throws Exception {
        return this.mydev.getError();
    }

    @Command(name="getnumberoferrors", description="returns num of stored errors, max of 5")
    public int getnumberoferrors() throws Exception {
        return this.mydev.getNumberOfErrors();
    }

    @Command(name="getunits", description="Returns units")
    public String getunits() throws Exception {
        return this.mydev.getUnits();
    }

    @Command(name="setwave", description="Set wavelength")
    public double setwave(@Argument(name="wave", description="wavelength in double precision") double wave) throws Exception {
        this.mydev.setWave(wave);
        return this.mydev.getWave();
    }

    @Command(name="getwave", description="Return wavelength")
    public double getwave() throws Exception {
        return this.mydev.getWave();
    }

    @Command(name="setbandpass", description="Set bandpass")
    public double setbandpass(@Argument(name="bandpass", description="bandpass in double precision") double bandpass) throws Exception {
        this.mydev.setBandpass(bandpass);
        return this.mydev.getBandpass();
    }

    @Command(name="getbandpass", description="Return bandpass")
    public double getbandpass() throws Exception {
        return this.mydev.getBandpass();
    }

    @Command(name="setfilter", description="Set filter")
    public int setfilter(@Argument(name="filter", description="filter integer") int filter) throws Exception {
        this.mydev.setFilter(filter);
        return this.mydev.getFilter();
    }

    @Command(name="getfilter", description="Returns filter position [1,6]")
    public int getfilter() throws Exception {
        return this.mydev.getFilter();
    }

    @Command(name="setfilterlabel", description="Set filter label for filter [1,6]")
    public String setfilterlabel(@Argument(name="filter", description="Filter [1,6]") int filter, @Argument(name="label", description="label") String label) throws Exception {
        this.mydev.setFilterLabel(filter, label);
        return this.mydev.getFilterLabel(filter);
    }

    @Command(name="getfilterlabel", description="Return filter label for filter [1,6]")
    public String getfilterlabel(@Argument(name="filter", description="Filter [1,6]") int filter) throws Exception {
        return this.mydev.getFilterLabel(filter);
    }

    @Command(name="setgrating", description="Moves wavelength drive to grating [1,2]")
    public String setgrating(@Argument(name="grating", description="grating 1 or 2") int grating) throws Exception {
        this.mydev.setGrating(grating);
        return this.mydev.getGrating();
    }

    @Command(name="getgrating", description="Return 3 parameters: grating [1,2], lines/mm, and label for grating")
    public String getgrating() throws Exception {
        return this.mydev.getGrating();
    }

    @Command(name="setgratinglabel", description="Set grating label")
    public String setgratinglabel(@Argument(name="param", description="1 or 2") int param, @Argument(name="label", description="label < 9 chars") String label) throws Exception {
        this.mydev.setGratingLabel(param, label);
        return this.mydev.getGratingLabel(param);
    }

    @Command(name="getgratinglabel", description="Return grating label")
    public String getgratinglabel(@Argument(name="param", description="1 or 2") int param) throws Exception {
        return this.mydev.getGratingLabel(param);
    }

    @Command(name="getgratinglines", description="Return grating lines")
    public int getgratinglines(@Argument(name="grat", description="1 or 2") int grat) throws Exception {
        return this.mydev.getGratingLines(grat);
    }

    @Command(name="getgratingfactor", description="Return grating factor")
    public double getgratingfactor(@Argument(name="grat", description="1 or 2") int grat) throws Exception {
        return this.mydev.getGratingFactor(grat);
    }

    @Command(name="getgratingoffset", description="Return grating offset")
    public double getgratingoffset(@Argument(name="grat", description="1 or 2") int grat) throws Exception {
        return this.mydev.getGratingOffset(grat);
    }

    @Command(name="getshutter", description="Returns shutter staus: C closed, O open")
    public String getshutter() throws Exception {
        return this.mydev.getShutter();
    }

    @Command(name="openshutter", description="open shutter")
    public void openShutter() throws Exception {
        this.mydev.openShutter();
    }

    @Command(name="closeshutter", description="close shutter")
    public void closeShutter() throws Exception {
        this.mydev.closeShutter();
    }

    @Command(name="isshutteropen", description="queries shutter returns true if open")
    public boolean isshutteropen() throws Exception {
        return this.mydev.isShutterOpen();
    }

    @Command(name="getslitsize", description="returns size in microns, 0 is an error cond")
    public int getslitsize(@Argument(name="slit", description="[1,3]") int slit) throws Exception {
        return this.mydev.getSlitSize(slit);
    }

    @Command(name="getstep", description="returns step position as measured from physical home sensors")
    public int getstep() throws Exception {
        return this.mydev.getStep();
    }

    @Command(name="write", description="write any string command")
    public void write(@Argument(name="cmd", description="String containing command") String cmd) throws Exception {
        this.mydev.writeMono(cmd);
    }

    @Command(name="read", description="read a response from Cornerstone")
    public String read() throws Exception {
        return this.mydev.readMono();
    }
}

