/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

public final class Constants {
    public static final int INDI_DEFAULT_PORT = 7624;
    public static final int BUFFER_SIZE = 1000000;
    public static final int WAITING_INTERVAL = 500;
    public static final int MILLISECONDS_IN_A_SECOND = 1000;

    private Constants() {
    }

    public static LightStates parseLightState(String state) {
        if (state.compareTo("Alert") == 0) {
            return LightStates.ALERT;
        }
        if (state.compareTo("Busy") == 0) {
            return LightStates.BUSY;
        }
        if (state.compareTo("Ok") == 0) {
            return LightStates.OK;
        }
        if (state.compareTo("Idle") == 0) {
            return LightStates.IDLE;
        }
        throw new IllegalArgumentException("Invalid LightState String: '" + state + "'");
    }

    public static boolean isValidLightState(String state) {
        try {
            Constants.parseLightState(state);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getLightStateAsString(LightStates lightState) {
        if (lightState == LightStates.ALERT) {
            return "Alert";
        }
        if (lightState == LightStates.BUSY) {
            return "Busy";
        }
        if (lightState == LightStates.OK) {
            return "Ok";
        }
        if (lightState == LightStates.IDLE) {
            return "Idle";
        }
        return "";
    }

    public static SwitchStatus parseSwitchStatus(String status) {
        if (status.compareTo("Off") == 0) {
            return SwitchStatus.OFF;
        }
        if (status.compareTo("On") == 0) {
            return SwitchStatus.ON;
        }
        throw new IllegalArgumentException("Invalid SwitchStatus String: '" + status + "'");
    }

    public static boolean isValidSwitchStatus(String status) {
        try {
            Constants.parseSwitchStatus(status);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getSwitchStatusAsString(SwitchStatus switchStatus) {
        if (switchStatus == SwitchStatus.ON) {
            return "On";
        }
        if (switchStatus == SwitchStatus.OFF) {
            return "Off";
        }
        return "";
    }

    public static PropertyPermissions parsePropertyPermission(String permission) {
        if (permission.compareTo("ro") == 0) {
            return PropertyPermissions.RO;
        }
        if (permission.compareTo("rw") == 0) {
            return PropertyPermissions.RW;
        }
        if (permission.compareTo("wo") == 0) {
            return PropertyPermissions.WO;
        }
        throw new IllegalArgumentException("Invalid PropertyPermissions String: '" + permission + "'");
    }

    public static boolean isValidPropertyPermission(String permission) {
        try {
            Constants.parsePropertyPermission(permission);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getPropertyPermissionAsString(PropertyPermissions permission) {
        if (permission == PropertyPermissions.RO) {
            return "ro";
        }
        if (permission == PropertyPermissions.RW) {
            return "rw";
        }
        if (permission == PropertyPermissions.WO) {
            return "wo";
        }
        return "";
    }

    public static PropertyStates parsePropertyState(String state) {
        if (state.compareTo("Alert") == 0) {
            return PropertyStates.ALERT;
        }
        if (state.compareTo("Busy") == 0) {
            return PropertyStates.BUSY;
        }
        if (state.compareTo("Ok") == 0) {
            return PropertyStates.OK;
        }
        if (state.compareTo("Idle") == 0) {
            return PropertyStates.IDLE;
        }
        throw new IllegalArgumentException("Invalid PropertyState String: '" + state + "'");
    }

    public static boolean isValidPropertyState(String state) {
        try {
            Constants.parsePropertyState(state);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getPropertyStateAsString(PropertyStates propertyState) {
        if (propertyState == PropertyStates.ALERT) {
            return "Alert";
        }
        if (propertyState == PropertyStates.BUSY) {
            return "Busy";
        }
        if (propertyState == PropertyStates.OK) {
            return "Ok";
        }
        if (propertyState == PropertyStates.IDLE) {
            return "Idle";
        }
        return "";
    }

    public static SwitchRules parseSwitchRule(String rule) {
        if (rule.compareTo("OneOfMany") == 0) {
            return SwitchRules.ONE_OF_MANY;
        }
        if (rule.compareTo("AtMostOne") == 0) {
            return SwitchRules.AT_MOST_ONE;
        }
        if (rule.compareTo("AnyOfMany") == 0) {
            return SwitchRules.ANY_OF_MANY;
        }
        throw new IllegalArgumentException("Invalid SwitchRules String: '" + rule + "'");
    }

    public static boolean isValidSwitchRule(String rule) {
        try {
            Constants.parseSwitchRule(rule);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getSwitchRuleAsString(SwitchRules rule) {
        if (rule == SwitchRules.ONE_OF_MANY) {
            return "OneOfMany";
        }
        if (rule == SwitchRules.AT_MOST_ONE) {
            return "AtMostOne";
        }
        if (rule == SwitchRules.ANY_OF_MANY) {
            return "AnyOfMany";
        }
        return "";
    }

    public static BLOBEnables parseBLOBEnable(String blobEnable) {
        if (blobEnable.compareTo("Never") == 0) {
            return BLOBEnables.NEVER;
        }
        if (blobEnable.compareTo("Also") == 0) {
            return BLOBEnables.ALSO;
        }
        if (blobEnable.compareTo("Only") == 0) {
            return BLOBEnables.ONLY;
        }
        throw new IllegalArgumentException("Invalid BLOBEnable String: '" + blobEnable + "'");
    }

    public static boolean isValidBLOBEnable(String blobEnable) {
        try {
            Constants.parseBLOBEnable(blobEnable);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String getBLOBEnableAsString(BLOBEnables blobEnable) {
        if (blobEnable == BLOBEnables.NEVER) {
            return "Never";
        }
        if (blobEnable == BLOBEnables.ALSO) {
            return "Also";
        }
        if (blobEnable == BLOBEnables.ONLY) {
            return "Only";
        }
        return "";
    }

    public static enum BLOBEnables {
        NEVER,
        ALSO,
        ONLY;

    }

    public static enum SwitchRules {
        ONE_OF_MANY,
        AT_MOST_ONE,
        ANY_OF_MANY;

    }

    public static enum PropertyStates {
        IDLE,
        OK,
        BUSY,
        ALERT;

    }

    public static enum PropertyPermissions {
        RO,
        RW,
        WO;

    }

    public static enum SwitchStatus {
        OFF,
        ON;

    }

    public static enum LightStates {
        IDLE,
        OK,
        BUSY,
        ALERT;

    }
}

