/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.util.ArrayList;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.mmm.MMMUtilities;
import org.lsst.ccs.subsystem.mmm.Minion;
import org.lsst.ccs.subsystem.mmm.MinionGroup;
import org.lsst.ccs.utilities.logging.Logger;

public class AlertNotifier {
    static Logger log = Logger.getLogger((String)"lsst.ccs.bus");
    private final Object updateInProgress = new Object();
    private final MMMUtilities mmmUtils;
    private final AlertService alertService;
    private final AgentPresenceManager apm;
    private final AgentInfo thisAgentInfo;
    ArrayList<Observer> observers = new ArrayList();

    public AlertNotifier(MMMUtilities mmmUtils, Agent agent) {
        this.mmmUtils = mmmUtils;
        this.alertService = (AlertService)agent.getAgentService(AlertService.class);
        this.alertService.addListener(event -> this.processEvent(event));
        this.apm = agent.getMessagingAccess().getAgentPresenceManager();
        this.thisAgentInfo = agent.getAgentInfo();
    }

    private void processEvent(AlertEvent event) {
        if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED) {
            String origin = event.getSource();
            AgentInfo ai = null;
            if (this.thisAgentInfo.getName().equals(origin)) {
                ai = this.thisAgentInfo;
            } else {
                for (AgentInfo info : this.apm.listConnectedAgents()) {
                    if (!info.getName().equals(origin)) continue;
                    ai = info;
                    break;
                }
            }
            if (ai == null) {
                log.log(Level.SEVERE, "Could not find connected agent for origin: {0}", (Object)origin);
            }
            if (origin.contains("MMM")) {
                log.info((Object)("Got a raised alert message from " + origin + " -- ignored, source = MMM"));
                return;
            }
            MinionGroup g = this.mmmUtils.getSubsystemGroup(origin);
            try {
                Minion m = this.mmmUtils.getSubsystemType(origin);
                if (m != null) {
                    Alert alert = event.getAlert();
                    log.info((Object)("Got a raised alert message from " + origin));
                    RaisedAlertHistory hist = event.getSummary().getRaisedAlert(alert.getAlertId());
                    AlertNotification an = ai == null ? new AlertNotification(origin, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertCCSTimeStamp().getUTCInstant().toEpochMilli()) : new AlertNotification(ai, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertCCSTimeStamp().getUTCInstant().toEpochMilli());
                    this.notifyObservers(an);
                } else {
                    log.log(Level.WARNING, "Cannot process alert from origin {0} ({1})", new Object[]{origin, event.getAlert()});
                }
            }
            catch (MMMUtilities.UnknownMinionException e) {
                log.warning((Object)("Could not process event " + event), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(AlertNotification notif) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, notif));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, origin, summary));
        }
    }

    private void notifyObserver(Observer o, AlertNotification notif) {
        o.alertRaised(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserver(Observer o, String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            for (RaisedAlertHistory hist : summary.getAllRaisedAlertHistories()) {
                if (hist.getLatestAlertState() == AlertState.NOMINAL) continue;
                try {
                    MinionGroup g = this.mmmUtils.getSubsystemGroup(origin);
                    Minion m = this.mmmUtils.getSubsystemType(origin);
                    this.notifyObserver(o, new AlertNotification(origin, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertCCSTimeStamp().getUTCInstant().toEpochMilli()));
                }
                catch (Exception e) {
                    log.warning((Object)("Could not process alert notification from " + origin), (Throwable)e);
                }
            }
        }
    }

    public static interface Observer {
        public void alertRaised(AlertNotification var1);
    }
}

