/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class INDIPipedConnections {
    private static final Logger LOG;
    private final INDIPipedConnection first;
    private final INDIPipedConnection second;

    public INDIPipedConnections() {
        LinkedBlockingQueue firstToSecondQueue = new LinkedBlockingQueue();
        LinkedBlockingQueue secondToFirstQueue = new LinkedBlockingQueue();
        this.first = new INDIPipedConnection(firstToSecondQueue, secondToFirstQueue);
        this.second = new INDIPipedConnection(secondToFirstQueue, firstToSecondQueue);
    }

    public INDIConnection first() {
        return this.first;
    }

    public INDIConnection second() {
        return this.second;
    }

    static {
        INDIURLStreamHandlerFactory.init();
        LOG = LoggerFactory.getLogger(INDIPipedConnections.class);
    }

    private static final class INDIProtokolEndMarker
    extends INDIProtocol<Object> {
        private INDIProtokolEndMarker() {
        }
    }

    private static final class INDIPipedOutputStream
    implements INDIOutputStream {
        private final INDIPipedConnection connection;
        private final LinkedBlockingQueue<INDIProtocol<?>> outputQueue;

        private INDIPipedOutputStream(LinkedBlockingQueue<INDIProtocol<?>> outputQueue, INDIPipedConnection connection) {
            this.outputQueue = outputQueue;
            this.connection = connection;
        }

        @Override
        public void close() throws IOException {
            this.connection.close();
            try {
                this.outputQueue.put(new INDIProtokolEndMarker());
            }
            catch (InterruptedException e) {
                LOG.error("closing on a closed stream, ignoring it", (Throwable)e);
            }
        }

        @Override
        public synchronized void writeObject(INDIProtocol<?> element) throws IOException {
            if (this.connection.isClosed()) {
                throw new IOException("stream closed");
            }
            try {
                this.outputQueue.put(element);
            }
            catch (InterruptedException e) {
                this.connection.close();
                throw new IOException("queue closed", e);
            }
        }
    }

    private static final class INDIPipedInputStream
    implements INDIInputStream {
        private final INDIPipedConnection connection;
        private final LinkedBlockingQueue<INDIProtocol<?>> inputQueue;

        private INDIPipedInputStream(LinkedBlockingQueue<INDIProtocol<?>> inputQueue, INDIPipedConnection connection) {
            this.inputQueue = inputQueue;
            this.connection = connection;
        }

        @Override
        public void close() throws IOException {
            this.connection.close();
        }

        @Override
        public INDIProtocol<?> readObject() throws IOException {
            if (this.connection.isClosed()) {
                return null;
            }
            try {
                INDIProtocol<?> readObject = this.inputQueue.take();
                if (readObject instanceof INDIProtokolEndMarker) {
                    return null;
                }
                readObject.trim();
                return readObject;
            }
            catch (InterruptedException e) {
                this.connection.close();
                return null;
            }
        }
    }

    private static final class INDIPipedConnection
    implements INDIConnection {
        private boolean closed = false;
        private INDIInputStream inputStream;
        private INDIOutputStream outputStream;

        public INDIPipedConnection(LinkedBlockingQueue<INDIProtocol<?>> inputQueue, LinkedBlockingQueue<INDIProtocol<?>> outputQueue) {
            this.inputStream = new INDIPipedInputStream(inputQueue, this);
            this.outputStream = new INDIPipedOutputStream(outputQueue, this);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public INDIInputStream getINDIInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public INDIOutputStream getINDIOutputStream() throws IOException {
            return this.outputStream;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public URL getURL() {
            try {
                return new URL("indi:///?pipe");
            }
            catch (MalformedURLException e) {
                LOG.error("illegal std url, should never happen!", (Throwable)e);
                return null;
            }
        }
    }
}

