/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.brakewatch;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;

public class BrakeWatch
extends Subsystem
implements HasLifecycle,
StatusMessageListener,
AlertListener,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(BrakeWatch.class.getName());
    private volatile AgentMessagingLayer aml;
    private volatile Subsystem subsys = this;
    @ConfigurationParameter(description="The key of the brake voltage value in the KeyValueDataList.", isFinal=true, units="unitless")
    private volatile String brakeVoltageKey = "PDU_24VD/Shtr_Brakes_V";
    @ConfigurationParameter(description="Brake power voltage must be at least this to be considered 'on'.", isFinal=true, units="V")
    private volatile double powerOnThreshold = 23.0;

    public BrakeWatch() {
        super("brakewatch", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).addListener((AlertListener)this);
        ((AlertService)this.subsys.getAgentService(AlertService.class)).startStatusAlertListening(a -> true);
        LOG.finer(() -> "Started listening for the alert " + this.brakeVoltageKey);
    }

    public void postStart() {
        this.aml = this.subsys.getMessagingAccess();
        this.aml.addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().hasAgentProperty("quadBoxAgent") && msg instanceof StatusSubsystemData && ((StatusSubsystemData)msg).getObject() instanceof KeyValueDataList);
        LOG.info(() -> "Started listening for brake-voltage status messages.");
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        LOG.info(() -> "Started listening for agent-presence events.");
        List onlineAgents = this.aml.getAgentPresenceManager().listConnectedAgents();
        onlineAgents.stream().filter(agent -> agent.hasAgentProperty("quadBoxAgent")).forEach(agent -> LOG.log(Level.INFO, "Agent {0} has property {1} = {2}.", new Object[]{agent.toString(), "quadBoxAgent", agent.getAgentProperty("quadBoxAgent")}));
    }

    public void postShutdown() {
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
        LOG.info(() -> "Stopped listening for status bus messages from quadbox.");
        this.aml.getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        LOG.info(() -> "Stopped listening for agent-presence events for quadbox.");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).removeListener((AlertListener)this);
        LOG.info(() -> "Stopped listening for alerts from quadbox.");
    }

    public void onStatusMessage(StatusMessage rawMsg) {
        List kvdList = ((KeyValueDataList)((StatusSubsystemData)rawMsg).getObject()).getListOfKeyValueData();
        Optional<KeyValueData> kvd = kvdList.stream().filter(k -> k.getKey().equals(this.brakeVoltageKey)).findFirst();
        if (kvd.isPresent()) {
            LOG.info(() -> "Received this brake-power message: " + rawMsg.toString());
            double voltage = (Double)kvd.get().getValue();
            this.sendPowerEvent(voltage >= this.powerOnThreshold);
        }
    }

    public void onAlert(AlertEvent event) {
        switch (event.getType()) {
            case AGENT_CONNECTION: {
                break;
            }
            case AGENT_DISCONNECTION: {
                break;
            }
            case ALERT_CLEARED: {
                List clearedIds = event.getClearedIds();
                boolean brakeAlertCleared = clearedIds.contains(this.brakeVoltageKey);
                if (!brakeAlertCleared) break;
                LOG.info(() -> "The brake voltage alert was cleared by agent " + event.getSource() + ".");
                this.sendPowerEvent(true);
                break;
            }
            case ALERT_RAISED: {
                Alert alrt = event.getAlert();
                if (!alrt.getAlertId().equals(this.brakeVoltageKey)) break;
                LOG.info(() -> "The brake voltage alert was raised by agent " + event.getSource() + ".");
                this.sendPowerEvent(event.getLevel() == AlertState.NOMINAL);
            }
        }
    }

    public void disconnected(AgentInfo ... agents) {
        Optional<AgentInfo> quadBoxDisc = Stream.of(agents).filter(a -> a.hasAgentProperty("quadBoxAgent")).findFirst();
        if (quadBoxDisc.isPresent()) {
            LOG.info(() -> "The quadbox agent " + ((AgentInfo)quadBoxDisc.get()).toString() + " has gone off-line.");
            this.sendPowerEvent(false);
        }
    }

    private void sendPowerEvent(boolean powerIsOn) {
        LOG.info(() -> "Queueing a power event with powerIsOn=" + powerIsOn);
    }
}

