/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.config.VacuumConfig;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class IonPumpControl
extends Control {
    private static final String VOLTAGE = "voltage";
    private static final String CURRENT = "current";
    private static final String POWER = "power";
    @ConfigurationParameter(name="voltage", category="Cryo", units="V", description="ion pump voltage setting")
    private volatile double voltage;
    @ConfigurationParameter(name="current", category="Cryo", units="A", description="ion pump current limit")
    private volatile double current;
    @ConfigurationParameter(name="power", category="Cryo", units="VA", description="ion pump power limit")
    private volatile double power;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    private static final Logger LOG = Logger.getLogger(IonPumpControl.class.getName());
    private String shortName;
    private IonPumpDevice pDevc;

    public void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.pDevc = (IonPumpDevice)devc;
        try {
            if (this.hwChan < 0 || this.hwChan >= 9) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)this.getName(), (String)"hw channel number", (Object)this.hwChan);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] parts = this.getName().split("\\.");
        this.shortName = parts[parts.length - 1];
    }

    @ConfigurationParameterChanger
    public void setVoltage(double value) throws VacuumException {
        this.voltage = value;
        if (this.pDevc != null && this.pDevc.isOnline()) {
            this.writeVoltage();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set voltage")
    public double getVoltage() {
        return this.voltage;
    }

    @ConfigurationParameterChanger
    public void setCurrent(double value) throws VacuumException {
        this.current = value;
        if (this.pDevc != null && this.pDevc.isOnline()) {
            this.writeCurrent();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set current")
    public double getCurrent() {
        return this.current;
    }

    @ConfigurationParameterChanger
    public void setPower(double value) throws VacuumException {
        this.power = value;
        if (this.pDevc != null && this.pDevc.isOnline()) {
            this.writePower();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the power")
    public double getPower() {
        return this.power;
    }

    @Command(type=Command.CommandType.ACTION, description="Changes the voltage")
    public void changeVoltage(double value) throws VacuumException {
        this.pDevc.setVoltage(this.hwChan, value);
    }

    void setConfig(VacuumConfig.Channel chan) {
        String name = this.getName();
        this.sce.change(name, VOLTAGE, (Object)chan.getVoltage());
        this.sce.change(name, CURRENT, (Object)chan.getCurrent());
        this.sce.change(name, POWER, (Object)chan.getPower());
    }

    VacuumConfig.Channel getConfig() {
        VacuumConfig.Channel chan = new VacuumConfig.Channel();
        chan.setName(this.shortName);
        chan.setVoltage(this.voltage);
        chan.setCurrent(this.current);
        chan.setPower(this.power);
        return chan;
    }

    void writeAll() throws Exception {
        this.writeVoltage();
        this.writeCurrent();
        this.writePower();
    }

    void writeVoltage() throws VacuumException {
        this.pDevc.setVoltage(this.hwChan, this.voltage);
    }

    void writeCurrent() throws VacuumException {
        this.pDevc.setCurrent(this.hwChan, this.current);
    }

    void writePower() throws VacuumException {
        this.pDevc.setPower(this.hwChan, this.power);
    }

    void powerOn() throws VacuumException {
        this.pDevc.powerOn(this.hwChan);
    }

    void powerOff() throws VacuumException {
        this.pDevc.powerOff(this.hwChan);
    }
}

