/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N6517;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestN6517
extends TestScpi {
    private final N6517 n65;

    public TestN6517() {
        super((Scpi)new N6517());
        this.n65 = (N6517)this.scpi;
    }

    @Command(name="open", description="Open connection to device using defaults")
    public void open() throws DriverException {
        this.n65.open();
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.n65.open(host);
        return this.n65.printdevid();
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.n65.open(host, port);
        return this.n65.printdevid();
    }

    @Command(name="setrate", description="Set read rate")
    public void setRate(@Argument(name="value", description="number of power cycles") int value) throws DriverException {
        this.n65.setRate(value);
    }

    @Command(name="setarmcount", description="Set the ARM count")
    public void setArmCount(@Argument(name="value", description="ARM count") int value) throws DriverException {
        this.n65.setArmCount(value);
    }

    @Command(name="settrigcount", description="Set the trigger count")
    public void setTrigCount(@Argument(name="value", description="trigger count") int value) throws DriverException {
        this.n65.setTrigCount(value);
    }

    @Command(name="clrbuff", description="Clear the read buffer")
    public void clearBuffer() throws DriverException {
        this.n65.clrBuff();
    }

    @Command(name="readbuff", description="read the buffer")
    public String readBuffer() throws DriverException {
        return "Buffer = " + this.getString(this.n65.readBuffer());
    }

    @Command(name="reset", description="reset the device to a useable state")
    public void reset() throws DriverException {
        this.n65.reset();
    }

    @Command(name="setbuffsize", description="Set the buffer size.")
    public void setBuffSize(@Argument(name="value", description="buffer size") int value) throws DriverException {
        this.n65.setBuffSize(value);
    }

    @Command(name="setvoltagerange", description="Set the voltage range. Can be 10V, 50V or 500V")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set") double value) throws DriverException {
        this.n65.setVoltageRange(value);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n65.setVoltage(value);
    }

    @Command(name="rampvolts", description="Set the voltage")
    public void rampVolts(@Argument(name="duration", description="number of second for the ramp") double duration, @Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n65.rampVolts(duration, value);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException {
        return "Voltage = " + this.n65.getVoltage();
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.n65.readVoltage();
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.n65.setVoltageLimit(value);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.n65.getVoltageLimit();
    }

    @Command(name="setcurrentrange", description="Set the current range")
    public void setCurrentRange(@Argument(name="value", description="Current Range to set") double value) throws DriverException {
        this.n65.setCurrentRange(value);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.n65.setCurrent(value);
    }

    @Command(name="zerocorrectcurrent", description="Zero correct the current")
    public void zeroCorrectCurrent() throws DriverException {
        this.n65.zeroCorrectCurrent();
    }

    @Command(name="showcurrent", description="Show the set current")
    public String getCurrent() throws DriverException {
        return "Current = " + this.n65.getCurrent();
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.n65.readCurrent();
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.n65.setCurrentLimit(value);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "Current limit = " + this.n65.getCurrentLimit();
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") onOff state) throws DriverException {
        this.n65.setOutput(state == onOff.ON);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.n65.getOutput());
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

