/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO;

public class CanOpenEPOSCarouselClamp
extends CanOpenEPOS {
    private static final Logger FCSLOG = Logger.getLogger(CanOpenEPOSCarouselClamp.class.getName());
    protected int cobid1;
    private long pdo1;

    public CanOpenEPOSCarouselClamp() {
        this.cobid1 = this.nodeID + 384;
        this.pdo1 = 0L;
    }

    @Override
    public void init() {
        super.init();
        this.cobid1 = this.nodeID + 384;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSLOG.finer(() -> this.name + " updatingFromPDO = " + pdo);
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSLOG.finer(() -> this.name + " updatingFromPDO1 = " + this.pdo1 + " binary:" + Long.toBinaryString(this.pdo1));
            this.statusWord = CanOpenEPOSWithPDO.extractStatusWord(this.pdo1);
            this.updateEposState(this.statusWord);
            this.averageCurrent = (short)CanOpenEPOSWithPDO.extractAverageCurrent(this.pdo1);
            this.velocity = CanOpenEPOSWithPDO.extractAverageVelocity(this.pdo1);
        }
        if (updated) {
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("Values of the carousel clamp controller (one unique PDO)");
        sb.append("=> pdo1 value = " + this.pdo1);
        sb.append(" / 0x" + Long.toHexString(this.pdo1));
        sb.append("\n status word = 0b" + Long.toBinaryString(this.statusWord));
        sb.append(" / 0x" + Long.toHexString(this.statusWord));
        sb.append("\n average current = " + this.averageCurrent);
        sb.append(" / 0x" + Long.toHexString(this.averageCurrent));
        sb.append("\n average velocity = " + this.velocity);
        sb.append(" / 0x" + Long.toHexString(this.velocity));
        return sb.toString();
    }
}

