/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;

public class SimMaq20 {
    private static final RangeSpec[] idRangeSpecs = new RangeSpec[]{new RangeSpec(-3, 0, 20), new RangeSpec(-3, 4, 20)};
    private static final RangeSpec[] ioRangeSpecs = new RangeSpec[]{new RangeSpec(0, 0, 20), new RangeSpec(0, 4, 20)};
    private static final RangeSpec[] vdRangeSpecs = new RangeSpec[]{new RangeSpec(0, -60, 60), new RangeSpec(0, -40, 40), new RangeSpec(0, -20, 20), new RangeSpec(0, -10, 10), new RangeSpec(0, -5, 5)};
    private static final RangeSpec[] mvdRangeSpecs = new RangeSpec[]{new RangeSpec(0, -2, 2), new RangeSpec(0, -1, 1), new RangeSpec(-3, -250, 250), new RangeSpec(-3, -100, 100), new RangeSpec(-3, -50, 50)};
    private static final RangeSpec[] voRangeSpecs = new RangeSpec[]{new RangeSpec(0, -10, 10), new RangeSpec(0, -5, 5), new RangeSpec(-1, -25, 25), new RangeSpec(0, 0, 10), new RangeSpec(0, 0, 5), new RangeSpec(-1, 0, 25)};
    private static final RangeSpec[] tctRangeSpecs = new RangeSpec[]{new RangeSpec(0, -100, 400), new RangeSpec(0, -100, 220)};
    private static final RangeSpec[] tcjRangeSpecs = new RangeSpec[]{new RangeSpec(0, -100, 760), new RangeSpec(0, -100, 393), new RangeSpec(0, -100, 199)};
    private static final RangeSpec[] tckRangeSpecs = new RangeSpec[]{new RangeSpec(0, -100, 1350), new RangeSpec(0, -100, 651), new RangeSpec(0, -100, 332)};
    private static final RangeSpec[] tcrsRangeSpecs = new RangeSpec[]{new RangeSpec(0, 0, 1750), new RangeSpec(0, 0, 990), new RangeSpec(0, 0, 1750), new RangeSpec(0, 0, 970)};
    private static final RangeSpec[] rtdRangeSpecs = new RangeSpec[]{new RangeSpec(0, -200, 850), new RangeSpec(0, -200, 200), new RangeSpec(0, -100, 100)};
    private static final RangeSpec[] emptyRangeSpecs = new RangeSpec[0];
    private static final Map<Maq20.ModuleType, String> typeNameMap = new HashMap<Maq20.ModuleType, String>();
    private static final Map<Maq20.ModuleType, ModuleSpec> moduleSpecMap;
    private final Maq20 maq20;
    private final Map<Integer, Short> registerData = new HashMap<Integer, Short>();

    public SimMaq20(Maq20 maq20) {
        this.maq20 = maq20;
    }

    public void initialize(Maq20.ModuleType[] modTypes, String[] serials) {
        int nModule = Math.min(modTypes.length, serials.length);
        for (int id = 1; id <= nModule; ++id) {
            Maq20.ModuleType modType = modTypes[id - 1];
            int baseAddr = 2000 * id;
            this.setModuleName(id, "MAQ20-" + typeNameMap.get((Object)modType));
            this.setSerialNum(id, serials[id - 1]);
            this.writeRegister((short)(100 + id), (short)1);
            ModuleSpec modSpec = moduleSpecMap.get((Object)modType);
            this.writeRegister((short)(baseAddr + 40), modSpec.numInputChans);
            this.writeRegister((short)(baseAddr + 41), modSpec.numOutputChans);
            this.writeRegister((short)(baseAddr + 1700), (short)modSpec.rangeSpecs.length);
            for (int j = 0; j < modSpec.rangeSpecs.length; ++j) {
                int rangeBaseAddr = baseAddr + 1710 + 20 * j;
                RangeSpec rangeSpec = modSpec.rangeSpecs[j];
                this.writeRegister((short)(rangeBaseAddr + 8), (short)0);
                this.writeRegister((short)(rangeBaseAddr + 10), (short)8000);
                this.writeRegister((short)(rangeBaseAddr + 0), rangeSpec.engNegFs);
                this.writeRegister((short)(rangeBaseAddr + 2), rangeSpec.engPosFs);
                this.writeRegister((short)(rangeBaseAddr + 4), rangeSpec.engFsPower);
            }
        }
    }

    void setChannelValue(int modId, int chan, double value) throws DriverException {
        Maq20.ModuleData modData = this.maq20.getModuleData(modId, false);
        int range = modData.range[chan];
        short raw = (short)((value + modData.offset[range]) / modData.scale[range] + 0.5);
        this.writeRegister((short)(modData.baseAddr + 1000 + chan), raw);
    }

    short[] readRegisters(short addr, short count) {
        short[] values = new short[count];
        for (int j = 0; j < count; ++j) {
            Short value = this.registerData.get(addr + j);
            values[j] = value == null ? (short)0 : value;
        }
        return values;
    }

    void writeRegisters(short addr, short[] value) {
        for (int j = 0; j < value.length; ++j) {
            this.registerData.put(addr + j, value[j]);
        }
    }

    void writeRegister(short addr, short value) {
        this.registerData.put(Integer.valueOf(addr), value);
    }

    private void setModuleName(int modId, String modName) {
        short addr = (short)(2000 * modId + 0);
        this.writeRegisters(addr, this.makeShorts(modName));
    }

    private void setSerialNum(int modId, String serial) {
        short addr = (short)(2000 * modId + 20);
        this.writeRegisters(addr, this.makeShorts(serial));
    }

    private short[] makeShorts(String text) {
        short[] values = new short[text.length()];
        for (int j = 0; j < values.length; ++j) {
            values[j] = (short)text.charAt(j);
        }
        return values;
    }

    static {
        for (Map.Entry<String, Maq20.ModuleType> e : Maq20.typeMap.entrySet()) {
            typeNameMap.put(e.getValue(), e.getKey());
        }
        moduleSpecMap = new HashMap<Maq20.ModuleType, ModuleSpec>();
        moduleSpecMap.put(Maq20.ModuleType.DINP, new ModuleSpec(20, 0, emptyRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.DIOH, new ModuleSpec(5, 5, emptyRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.DIOL, new ModuleSpec(5, 5, emptyRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.DOUT, new ModuleSpec(0, 20, emptyRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.ID, new ModuleSpec(8, 0, idRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.IO, new ModuleSpec(0, 8, ioRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.IS, new ModuleSpec(16, 0, idRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.JTC, new ModuleSpec(8, 0, tcjRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.KTC, new ModuleSpec(8, 0, tckRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.MVD, new ModuleSpec(8, 0, mvdRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.RSTC, new ModuleSpec(8, 0, tcrsRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.RTD, new ModuleSpec(6, 0, rtdRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.TTC, new ModuleSpec(8, 0, tctRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.VD, new ModuleSpec(8, 0, vdRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.VO, new ModuleSpec(0, 8, voRangeSpecs));
        moduleSpecMap.put(Maq20.ModuleType.VS, new ModuleSpec(16, 0, vdRangeSpecs));
    }

    static class RangeSpec {
        short engFsPower;
        short engNegFs;
        short engPosFs;

        RangeSpec(int engFsPower, int engNegFs, int engPosFs) {
            this.engFsPower = (short)engFsPower;
            this.engNegFs = (short)engNegFs;
            this.engPosFs = (short)engPosFs;
        }
    }

    static class ModuleSpec {
        short numInputChans;
        short numOutputChans;
        RangeSpec[] rangeSpecs;

        ModuleSpec(int numInputChans, int numOutputChans, RangeSpec[] rangeSpecs) {
            this.numInputChans = (short)numInputChans;
            this.numOutputChans = (short)numOutputChans;
            this.rangeSpecs = rangeSpecs;
        }
    }
}

