/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.io.INDIProtocolFactory;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIProcessConnection
implements INDIConnection {
    private static final Logger LOG;
    private INDIInputStream inputStream;
    private INDIOutputStream outputStream;
    private final Process process;

    public INDIProcessConnection(Process process) {
        this.process = process;
    }

    @Override
    public INDIInputStream getINDIInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = INDIProtocolFactory.createINDIInputStream(this.process.getInputStream());
        }
        return this.inputStream;
    }

    @Override
    public INDIOutputStream getINDIOutputStream() throws IOException {
        if (this.inputStream == null) {
            this.outputStream = INDIProtocolFactory.createINDIOutputStream(this.process.getOutputStream());
        }
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public URL getURL() {
        try {
            return new URL("indi:///?process=" + this.process.toString());
        }
        catch (MalformedURLException e) {
            LOG.error("illegal std url, should never happen!", (Throwable)e);
            return null;
        }
    }

    static {
        INDIURLStreamHandlerFactory.init();
        LOG = LoggerFactory.getLogger(INDIProcessConnection.class);
    }
}

