/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class HeaterConv {
    private static final double[][] defaultConv = new double[][]{{0.01, 0.046}, {0.03, 0.127}, {0.05, 0.159}, {0.07, 0.19}, {0.09, 0.224}, {0.11, 0.257}, {0.13, 0.287}, {0.15, 0.313}, {0.17, 0.337}, {0.19, 0.359}, {0.21, 0.382}, {0.23, 0.405}, {0.25, 0.426}, {0.27, 0.446}, {0.29, 0.465}, {0.31, 0.484}, {0.33, 0.505}, {0.35, 0.537}, {0.37, 0.572}, {0.39, 0.605}, {0.41, 0.631}, {0.43, 0.65}, {0.45, 0.666}, {0.47, 0.678}, {0.49, 0.689}, {0.51, 0.698}, {0.53, 0.704}, {0.55, 0.707}, {0.67, 0.708}, {0.69, 0.717}, {0.71, 0.729}, {0.73, 0.742}, {0.75, 0.753}, {0.77, 0.766}, {0.79, 0.78}, {0.81, 0.796}, {0.83, 0.815}, {0.85, 0.834}, {0.87, 0.854}, {0.89, 0.874}, {0.91, 0.894}, {0.93, 0.915}, {0.95, 0.934}, {0.97, 0.951}, {0.99, 0.973}};
    private static final Logger LOG = Logger.getLogger(HeaterConv.class.getName());
    private static final Properties props;
    private final double[][][] convDutyToVolts = new double[12][][];

    void setNode(int node) {
        block4: for (int chan = 0; chan < 12; ++chan) {
            double corrn;
            this.convDutyToVolts[chan] = defaultConv;
            if (node == 0) continue;
            String propName = HeaterConv.getPropName(node, chan);
            String propValue = props.getProperty(propName);
            if (propValue == null) {
                LOG.log(Level.WARNING, "Property {0} not found: using default conversion", propName);
                continue;
            }
            String[] elements = propValue.split(";");
            if (elements.length < 3) {
                LOG.log(Level.WARNING, "Property {0} has fewer than 3 elements: using default conversion", propName);
                continue;
            }
            double[][] conv = new double[elements.length - 1][2];
            try {
                corrn = Double.valueOf(elements[0]);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "Property {0} has invalid correction factor ({1}): using default conversion", new Object[]{propName, elements[0]});
                continue;
            }
            for (int j = 0; j < elements.length - 1; ++j) {
                String[] pair = elements[j + 1].split(",");
                if (pair.length != 2) {
                    LOG.log(Level.WARNING, "Property {0} contains wrong-sized conversion pair ({1}): using default conversion", new Object[]{propName, elements[j + 1]});
                    continue block4;
                }
                try {
                    conv[j][0] = Double.valueOf(pair[0]);
                    conv[j][1] = Double.valueOf(pair[1]) / corrn;
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.WARNING, "Property {0} contains non-numeric conversion pair ({1}): using default conversion", new Object[]{propName, elements[j + 1]});
                    continue block4;
                }
                this.convDutyToVolts[chan] = conv;
            }
        }
    }

    double convVoltsAndDuty(boolean toDuty, int chan, double value) {
        double conv;
        int j;
        int in = toDuty ? 1 : 0;
        int out = 1 - in;
        double[][] convTable = this.convDutyToVolts[chan];
        for (j = 0; j < convTable.length && !(convTable[j][in] >= value); ++j) {
        }
        if (j == 0) {
            conv = convTable[j][out];
        } else if (j >= convTable.length) {
            conv = convTable[j - 1][out];
        } else {
            double[] cPrev = convTable[j - 1];
            double[] cCurr = convTable[j];
            conv = cPrev[out] + (cCurr[out] - cPrev[out]) / (cCurr[in] - cPrev[in]) * (value - cPrev[in]);
        }
        return conv;
    }

    static String getPropName(int node, int chan) {
        return "org.lsst.ccs.auxelex.heater.calib." + node + "." + chan;
    }

    static {
        String fileName = "HeaterCalib.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            LOG.log(Level.SEVERE, "Heater PS calibration properties file ({0}) not found", fileName);
        }
        props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
    }
}

