#! /usr/bin/python


__author__ = "virieux"
__date__ = "$13 sept. 2019 15:20:43$"

"""
Autochanger onlineClampYminus test sequence
===================================

"""
import sys
import time
from org.lsst.ccs.scripting import CCS
from java.time import Duration
from java.lang import Exception

class Autochanger(object):
    def __init__(self, subsystem_name, n_sequences):
        self.name = subsystem_name
        self.n_seq = n_sequences
        self.waitTime = 1

        self.onlineClampYminus = CCS.attachSubsystem(self.name + "/onlineClampYminus")
        self.yminusCtl = CCS.attachSubsystem(self.name + "/onlineClampYminusController")
        

    def wait_for_user(self, text):
        print("Next command: %s\n" % text)
        print("Press any key to proceed...")
        return raw_input()

    def readPosition(self):
        return int(self.yminusCtl.sendSynchCommand("readPosition"))

    def readMode(self):
        return str(self.yminusCtl.sendSynchCommand("readMode"))

    def littleNap(self):
        print("Sleeping %ds..." % self.waitTime)
        sleep(self.waitTime)   

    def homing(self):
#        self.wait_for_user("onlineClampYminus: homing")
        print("homing...")
        self.onlineClampYminus.sendSynchCommand("openInCurrentModeAndHoming")

    def open(self):
#        self.wait_for_user("onlineClampYminus: open")
        print("open mode PROFILE_POSITION")
        self.onlineClampYminus.sendSynchCommand("open")

    def close(self):
#        self.wait_for_user("onlineClampYminus: close")
        print("close mode PROFILE_POSITION")
        self.onlineClampYminus.sendSynchCommand("close")

    def lock(self):
#        self.wait_for_user("onlineClampYminus: lock")
        self.onlineClampYminus.sendSynchCommand("lock")

    def unlock(self):
#        self.wait_for_user("onlineClampYminus: unlock")
        self.onlineClampYminus.sendSynchCommand("unlock")

    def clamp_test_sequence(self):
        print("Position = %d" % self.readPosition())
        self.homing()
        print("Position = %d" % self.readPosition())
        self.close()
        print("Position = %d" % self.readPosition())
        self.open()
        print("Position = %d" % self.readPosition())
        self.close()
        print("Position = %d" % self.readPosition())

    def run_sequence(self):
        print(__doc__)

        print("Position = %d" % self.readPosition())
        print("Mode = %s" % self.readMode())
        self.wait_for_user("onlineClampYminus: begin sequence by homing")
        for i in range(self.n_seq):
            print("Sequence %d/%d" % (i+1, self.n_seq))
            self.clamp_test_sequence()
            
if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser()
    parser.add_argument(
        "-s", "--subsystem", 
        type=str, default="fcs", 
        choices=["fcs", "autochanger-standalone_AC1", "autochanger-standalone_AC2"],
        help="Name of the running subsystem: 'fcs' or 'autochanger-standalone_AC1/2'")
    parser.add_argument(
        "-n", "--n_sequences", 
        type=int, default=1,
        help="Number of cycles to go through.")
    args = parser.parse_args()

    Autochanger(args.subsystem, args.n_sequences).run_sequence()

