/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

public enum LocalDBAlert {
    BatchException("BatchException", "Exception caught when persisting batch"),
    BatchRollbackException("BatchRollbackException", "Exception caught when attempting to rollback batch"),
    BatchIngestionQueueSize("BatchIngestionQueueSize", "Ingestion Queue size Alert"),
    WrongStatePersistence("WrongStatePersistence", "Persistence layer persists two different agent states with the same id"),
    LongRunningProcesses("LongRunningProcesses", "Alert Raised when Long Running processes are detected");

    private final String id;
    private final String description;
    private final Map<String, Serializable> data = new HashMap<String, Serializable>();

    private LocalDBAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public LocalDBAlert addData(String key, Serializable o) {
        this.data.put(key, o);
        return this;
    }

    public Alert getAlert(String prefix, Exception ex) {
        String alertId = (String)(prefix != null ? prefix + "/" : "") + this.id;
        Alert a = new Alert(alertId, this.description);
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            this.data.put("stackTrace", (Serializable)((Object)sw.toString()));
            pw.close();
        }
        for (Map.Entry<String, Serializable> e : this.data.entrySet()) {
            a.addAlertData(this.id, (Serializable)a);
        }
        return a;
    }

    public static String getFirstException(Exception ex) {
        Throwable th = ex;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th.toString();
    }
}

