/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.Objects;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.State;

abstract class SimpleContext<C extends Context<?>>
implements Context<C> {
    private State<C> state;
    private final Actions actions;

    protected SimpleContext(Actions actions) {
        Objects.requireNonNull(actions, "Can't have a null Actions for a context.");
        this.state = null;
        this.actions = actions;
    }

    @Override
    public final synchronized State<C> getState() {
        return this.state;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void makeTransition(State<C> newState, Runnable action) {
        Objects.requireNonNull(newState, "newState can't be null.");
        State<C> oldState = this.getState();
        if (oldState != null) {
            oldState.exit();
        }
        if (action != null) {
            action.run();
        }
        SimpleContext simpleContext = this;
        synchronized (simpleContext) {
            this.state = newState;
        }
        newState.entry();
    }

    @Override
    public final Actions getActions() {
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        SimpleContext simpleContext = this;
        synchronized (simpleContext) {
            this.state = null;
        }
    }
}

