import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.BOTBench;
import org.lsst.ccs.subsystem.teststand.Fe55Shutter;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.KeysightDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["bot-bench"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

Class keithleyClass = Class.forName("org.lsst.ccs.subsystem.teststand.KeithleyDevice");
Class keysightClass = Class.forName("org.lsst.ccs.subsystem.teststand.KeysightDevice");
Class thorlabsFWClass = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice");
Class thorlabsSC10Class = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device");
Class Fe55ShutterClass = Class.forName("org.lsst.ccs.subsystem.teststand.Fe55Shutter");

builder.
    botbench (BOTBench) {


    PhotoDiode  (keithleyClass)
    {
        voltage  (Channel,
            description:"photodiode supply voltage", units:"V",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_VOLTAGE, offset:0.0, scale:1.0
            /*checkLo:"alarm", alarmLo:"AlarmHDWPD"*/
            /*checkHi:"alarm", alarmHi:"AlarmHDWPD"*/)

        current  (Channel,

            description:"photodiode supply current", units:"I",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_CURRENT, offset:0.0, scale:1.0
            /*checkLo:"alarm", alarmLo:"AlarmHDWPD"*/,
            /*checkHi:"alarm", alarmHi:"AlarmHDWPD"*/)
    }
    PhotoDiode2  (keysightClass)
    {
    }

    SpotProjFWheel (thorlabsFWClass)
    {
        SpotProjFWheelPos (Channel, 
                           description:"Spot projector filter wheel position",
                           devcName:"SpotProjFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    NeutralFWheel (thorlabsFWClass)
    {
        NeutralFWheelPos (Channel, 
                           description:"Neutral density filter wheel position",
                           devcName:"NeutralFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ColorFWheel (thorlabsFWClass)
    {
        ColorFWheelPos (Channel, 
                           description:"Color filter wheel position",
                           devcName:"ColorFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ProjectorShutter (thorlabsSC10Class)
    {
    }

    Fe55ShutterA (Fe55ShutterClass)
    {}

    Fe55ShutterB (Fe55ShutterClass)
    {}

}
