/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class PciClient {
    private static final Map<String, RegisterAccess> idMap = new HashMap<String, RegisterAccess>();
    private static boolean first = true;

    private static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebPci");
            first = false;
        }
    }

    private static String genIdIfcKey(int id, String ifc) {
        return id + ":" + (ifc == null ? "" : ifc);
    }

    public static class Global
    implements GlobalClient.Impl {
        private String[] idIfcs;

        @Override
        public void newGlobalClient(int[] ids, String[] ifcs) {
            this.idIfcs = new String[ids.length];
            for (int j = 0; j < ids.length; ++j) {
                String ifc = ifcs == null || j >= ifcs.length || ifcs[j] == null ? "" : ifcs[j];
                this.idIfcs[j] = PciClient.genIdIfcKey(ids[j], ifc);
            }
        }

        @Override
        public void deleteGlobalClient() {
        }

        @Override
        public int getHwType() {
            return 4;
        }

        @Override
        public void setRegisterList(int rebType, int[] registers) {
            int[] regs = (int[])registers.clone();
            for (String key : this.idIfcs) {
                RegisterAccess ra = (RegisterAccess)idMap.get(key);
                if (ra == null) continue;
                ra.regs.regList = regs;
            }
        }

        @Override
        public long triggerImage(String name) throws REBException {
            for (String key : this.idIfcs) {
                RegisterAccess ra = (RegisterAccess)idMap.get(key);
                if (ra == null) continue;
                ra.regs.imageName = name;
                int value = ra.regs.readReg(ra.handle, 8) & 3 | 4;
                ra.regs.writeReg(ra.handle, 9, value);
            }
            return 1000000L * System.currentTimeMillis();
        }
    }

    public static class Images
    implements ImageClient.Impl {
        long client;
        int version;
        String idIfc;
        RegisterAccess regAccess;

        Images(RegClient reg, int versn) {
            PciClient.loadLibrary();
            Images.initSys();
            this.version = versn;
        }

        private static native void initSys();

        @Override
        public void newImageClient(int id, String ifc) throws REBException {
            this.newImageClient1(id, ifc, this.version);
            this.idIfc = PciClient.genIdIfcKey(id, ifc);
            if (idMap.get(this.idIfc) == null) {
                Registers regs = new Registers();
                this.regAccess = new RegisterAccess(regs, regs.newRegClient(id, ifc));
            }
        }

        public native void newImageClient1(int var1, String var2, int var3);

        @Override
        public void deleteImageClient() {
            if (this.regAccess != null) {
                this.regAccess.regs.deleteRegClient(this.regAccess.handle);
                this.regAccess = null;
            }
            this.deleteImageClient1();
        }

        public native void deleteImageClient1();

        @Override
        public Image waitForImage(Image image) {
            RegisterAccess ra;
            Image newImage = this.waitForImage1(image);
            RegisterAccess registerAccess = ra = this.regAccess != null ? this.regAccess : (RegisterAccess)idMap.get(this.idIfc);
            if (ra != null) {
                try {
                    int nCcds;
                    newImage.name = ra.regs.imageName;
                    int[] values = new int[2];
                    ra.regs.readRegs(ra.handle, 0x800001, values, 0, values.length);
                    newImage.sciId = (long)values[0] | (long)(values[1] & 0xFFFF) << 32;
                    ra.regs.readRegs(ra.handle, 1, values, 0, values.length);
                    newImage.sciVersion = values[0];
                    newImage.numCcds = nCcds = values[0] >> 28;
                    newImage.stripes = newImage.length / 16 / nCcds;
                    newImage.sensorType = nCcds == 1 ? 2 : (nCcds == 2 ? 1 : 0);
                    newImage.address = values[1];
                    newImage.members = new int[]{values[1]};
                    ra.regs.readRegs(ra.handle, 14, values, 0, values.length);
                    newImage.timestamp = 10L * ((long)values[0] + ((long)values[1] << 32));
                    newImage.registers = new int[ra.regs.regList.length];
                    for (int j = 0; j < ra.regs.regList.length; ++j) {
                        newImage.registers[j] = ra.regs.readReg(ra.handle, ra.regs.regList[j]);
                    }
                    newImage.partition = "";
                    newImage.platform = "";
                    newImage.clientVersion = "";
                    newImage.serverVersion = "";
                    newImage.interleaved = true;
                }
                catch (REBException rEBException) {
                    // empty catch block
                }
            }
            return newImage;
        }

        private native Image waitForImage1(Image var1);

        @Override
        public native boolean getImage(Image var1);

        @Override
        public native void reset();

        @Override
        public native void deleteImageMetadataRef(Image var1);
    }

    public static class Registers
    implements RegClient.Impl {
        int[] regList = new int[0];
        String imageName;

        Registers() {
            PciClient.loadLibrary();
        }

        @Override
        public synchronized long newRegClient(int id, String ifc) {
            long handle = this.newRegClient1(id, ifc);
            idMap.put(PciClient.genIdIfcKey(id, ifc), new RegisterAccess(this, handle));
            return handle;
        }

        public native long newRegClient1(int var1, String var2);

        @Override
        public synchronized void deleteRegClient(long handle) {
            for (String key : idMap.keySet()) {
                if (((RegisterAccess)idMap.get((Object)key)).handle != handle) continue;
                idMap.remove(key);
                break;
            }
            this.deleteRegClient1(handle);
        }

        public native void deleteRegClient1(long var1);

        @Override
        public int readReg(long handle, int address) throws REBException {
            int[] data = new int[1];
            this.readRegs(handle, address, data, 0, 1);
            return data[0];
        }

        @Override
        public synchronized native void readRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public void writeReg(long handle, int address, int value) throws REBException {
            int[] data = new int[]{value};
            this.writeRegs(handle, address, data, 0, 1);
        }

        @Override
        public synchronized native void writeRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public int updateReg(long handle, int address, int mask, int value) throws REBException {
            int oldValue = this.readReg(handle, address);
            this.writeReg(handle, address, oldValue & ~mask | value & mask);
            return oldValue;
        }
    }

    static class RegisterAccess {
        long handle;
        Registers regs;

        RegisterAccess(Registers regs, long handle) {
            this.handle = handle;
            this.regs = regs;
        }
    }
}

