/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.url;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.io.INDISocketConnection;
import org.indilib.i4j.protocol.io.INDIZipSocketConnection;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;

public class INDIURLConnection
extends URLConnection
implements INDIConnection {
    private INDISocketConnection socketConnection;

    protected INDIURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.socketConnection == null) {
            String host;
            int port = this.getURL().getPort();
            if (port <= 0) {
                port = this.getURL().getDefaultPort();
            }
            if ((host = this.getURL().getHost()) == null || host.isEmpty()) {
                host = "localhost";
            }
            try {
                this.socketConnection = "indiz".equals(this.getURL().getProtocol()) ? new INDIZipSocketConnection(host, port) : new INDISocketConnection(host, port);
            }
            catch (IOException e) {
                throw new IOException("Problem connecting to " + host + ":" + port);
            }
            this.connected = true;
        }
    }

    @Override
    public INDIInputStream getINDIInputStream() throws IOException {
        return this.getSocketConnection().getINDIInputStream();
    }

    @Override
    public INDIOutputStream getINDIOutputStream() throws IOException {
        return this.getSocketConnection().getINDIOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return (InputStream)((Object)this.getINDIInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return (OutputStream)((Object)this.getINDIOutputStream());
    }

    private INDIConnection getSocketConnection() throws IOException {
        this.connect();
        return this.socketConnection;
    }

    @Override
    public void close() throws IOException {
        if (this.socketConnection != null) {
            this.socketConnection.close();
        }
    }

    public static Map<String, List<String>> splitQuery(URL url) {
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        try {
            if (url != null && url.getQuery() != null) {
                String[] pairs;
                for (String pair : pairs = url.getQuery().split("&")) {
                    String key;
                    int idx = pair.indexOf("=");
                    String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                    if (!queryPairs.containsKey(key)) {
                        queryPairs.put(key, new LinkedList());
                    }
                    String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                    ((List)queryPairs.get(key)).add(value);
                }
            }
            return queryPairs;
        }
        catch (UnsupportedEncodingException e) {
            return queryPairs;
        }
    }

    static {
        INDIURLStreamHandlerFactory.init();
    }
}

