/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.Direction;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;

public class CalibDone
extends MsgToCCS {
    private static int TRANSITION_COUNT = 240;
    private final Map<Axis, Double> homePosition = new EnumMap<Axis, Double>(Axis.class);
    private final Map<Axis, Double> deployedPosition;
    private final Map<Axis, Map<Direction, double[]>> axisTransitions;

    public CalibDone(int sequence, double[] homePosition, double[] deployedPosition, DoubleSupplier supplier) {
        super(sequence);
        this.homePosition.put(Axis.AXIS0, homePosition[0]);
        this.homePosition.put(Axis.AXIS1, homePosition[1]);
        this.deployedPosition = new EnumMap<Axis, Double>(Axis.class);
        this.deployedPosition.put(Axis.AXIS0, deployedPosition[0]);
        this.deployedPosition.put(Axis.AXIS1, deployedPosition[1]);
        this.axisTransitions = CalibDone.makeTransitionMap(supplier);
    }

    public CalibDone(ByteBuffer data) {
        super(data);
        this.homePosition.put(Axis.AXIS0, data.getDouble());
        this.homePosition.put(Axis.AXIS1, data.getDouble());
        this.deployedPosition = new EnumMap<Axis, Double>(Axis.class);
        this.deployedPosition.put(Axis.AXIS0, data.getDouble());
        this.deployedPosition.put(Axis.AXIS1, data.getDouble());
        DoubleSupplier supplier = () -> data.getDouble();
        this.axisTransitions = CalibDone.makeTransitionMap(supplier);
    }

    private static Map<Axis, Map<Direction, double[]>> makeTransitionMap(DoubleSupplier supplier) {
        EnumMap<Axis, Map<Direction, double[]>> axisTransitions = new EnumMap<Axis, Map<Direction, double[]>>(Axis.class);
        for (Axis ax : Axis.values()) {
            EnumMap<Direction, double[]> directions = new EnumMap<Direction, double[]>(Direction.class);
            for (Direction di : Direction.values()) {
                double[] trans = new double[TRANSITION_COUNT];
                for (int i = 0; i < trans.length; ++i) {
                    trans[i] = supplier.getAsDouble();
                }
                directions.put(di, trans);
            }
            axisTransitions.put(ax, directions);
        }
        return axisTransitions;
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        for (Axis ax : Axis.values()) {
            data.putDouble(this.homePosition.get((Object)ax));
        }
        for (Axis ax : Axis.values()) {
            data.putDouble(this.deployedPosition.get((Object)ax));
        }
        for (Axis ax : Axis.values()) {
            for (Direction di : Direction.values()) {
                double[] trans = this.getHallTransitions(ax, di);
                for (int i = 0; i < trans.length; ++i) {
                    data.putDouble(trans[i]);
                }
            }
        }
    }

    public double[] getHallTransitions(Axis axis, Direction direction) {
        return this.axisTransitions.get((Object)axis).get((Object)direction);
    }

    public double getHomePosition(Axis ax) {
        return this.homePosition.get((Object)ax);
    }

    public double getDeployedPosition(Axis ax) {
        return this.deployedPosition.get((Object)ax);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("CalibDone{" + super.toString());
        for (Axis ax : Axis.values()) {
            buf.append(", home[");
            buf.append((Object)ax);
            buf.append("]=");
            buf.append(this.homePosition.get((Object)ax));
        }
        for (Axis ax : Axis.values()) {
            buf.append(", deployed[");
            buf.append((Object)ax);
            buf.append("]=");
            buf.append(this.deployedPosition.get((Object)ax));
        }
        for (Axis ax : Axis.values()) {
            for (Direction di : Direction.values()) {
                DoubleStream pos = Arrays.stream(this.getHallTransitions(ax, di));
                buf.append(", transitions[");
                buf.append((Object)ax);
                buf.append("][");
                buf.append((Object)di);
                buf.append("]={");
                buf.append(pos.mapToObj(Double::toString).collect(Collectors.joining(", ")));
                buf.append("}");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

