/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.mockquad;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;

public class MockQuad
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected volatile Subsystem subsys;
    private static final String BRAKE_VOLTAGE_KEY = "PDU_24VD/Shtr_Brakes_V";
    private static final Alert POWER_ALERT = new Alert("PDU_24VD/Shtr_Brakes_V", "Shutter brake power status.");

    public MockQuad() {
        super("mock-quadbox", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).registerAlert(POWER_ALERT, ClearAlertHandler.ALWAYS);
        KeyValueData msg = new KeyValueData(BRAKE_VOLTAGE_KEY, (Serializable)Double.valueOf(0.0));
        ((DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class)).registerData(msg);
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("quadBoxAgent", ((Object)((Object)this)).getClass().getSimpleName());
    }

    public void postShutdown() {
    }

    @Command(type=Command.CommandType.QUERY, description="Raise the power alert at severity WARNING.")
    public void raiseAlert() {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(POWER_ALERT, AlertState.WARNING, "Brake power lost.");
    }

    @Command(type=Command.CommandType.QUERY, description="Publish a new shutter brake power voltage.")
    public void publishVoltage(double v) {
        KeyValueData kvd = new KeyValueData(BRAKE_VOLTAGE_KEY, (Serializable)Double.valueOf(v));
        KeyValueDataList kvdl = new KeyValueDataList();
        kvdl.addData(kvd);
        this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }
}

