/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.thorlabs;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class ThorlabsSC10 {
    private final int BAUD_DEFAULT = 9600;
    private final int CHAR_TIMEOUT = 200;
    private final int INIT_TIMEOUT = 10000;
    private static final String Lbl = "ThorlabsSC10 ";
    private int initTimeout = 10000;
    private int finalTimeout = 200;
    private final Session session = new Session(0, ">", "", "", null, Ascii.Terminator.CR);

    public void open(String serialName, int baudRate) throws DriverException {
        DataRate dataRate = DataRate.valueOf("BAUD_" + Integer.toString(baudRate));
        this.session.open(Session.ConnType.SERIAL, serialName, baudRate, this.finalTimeout);
        this.session.setTimeout(this.initTimeout);
        try {
            this.setSC(CmndSC.DATA_RATE, dataRate.getCode());
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.open(serialName, 9600);
    }

    public void close() throws DriverException {
        this.session.close();
    }

    public void setSC(CmndSC cmnd, int setting) throws DriverException {
        if (!cmnd.setAllowed) {
            throw new DriverException("ThorlabsSC10 Write not allowed for " + cmnd.toString());
        }
        String[] reply = this.session.receive(cmnd.getCommand() + "=" + Integer.toString(setting));
        if (reply.length > 1) {
            if (reply[1].startsWith("Command error")) {
                throw new DriverException(Lbl + reply[1]);
            }
            throw new DriverException("ThorlabsSC10 unexpected reply: " + reply[1]);
        }
    }

    public String querySC(CmndSC query) throws DriverException {
        if (!query.queryAllowed) {
            throw new DriverException("ThorlabsSC10 Read not allowed for " + query.toString());
        }
        String[] reply = this.session.receive(query.getCommand() + "?");
        if (reply.length != 2) {
            throw new DriverException("ThorlabsSC10 unexpected reply length: " + reply.length + " lines");
        }
        if (reply[1].startsWith("Command error")) {
            throw new DriverException(Lbl + reply[1]);
        }
        return reply[1];
    }

    public void processSC(CmndSC cmnd) throws DriverException {
        String[] reply = this.session.receive(cmnd.getCommand());
        if (reply.length > 1) {
            if (reply[1].startsWith("Command error")) {
                throw new DriverException(Lbl + reply[1]);
            }
            throw new DriverException("ThorlabsSC10 unexpected reply: " + reply[1]);
        }
    }

    public void enable() throws DriverException {
        this.processSC(CmndSC.ENABLE);
    }

    public void saveSC() throws DriverException {
        this.processSC(CmndSC.SAVE);
    }

    public void saveProm() throws DriverException {
        this.processSC(CmndSC.SAVE_TO_PROM);
    }

    public void loadProm() throws DriverException {
        this.processSC(CmndSC.LOAD_FROM_PROM);
    }

    void setDebug(boolean debugMode) {
        this.session.setDebug(debugMode);
    }

    static enum DataRate {
        BAUD_9600(0),
        BAUD_115200(1);

        private int rateCode;

        private DataRate(int rateCode) {
            this.rateCode = rateCode;
        }

        private int getCode() {
            return this.rateCode;
        }
    }

    public static enum TrigMode {
        INTERNAL(0),
        EXTERNAL(1);

        private int setting;

        private TrigMode(int setting) {
            this.setting = setting;
        }

        public int getSetting() {
            return this.setting;
        }

        public static String decode(String code) throws DriverException {
            TrigMode[] mode = TrigMode.values();
            int n = mode.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (mode[i].setting != Integer.parseInt(code)) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("ThorlabsSC10 invalid code for trigger mode");
            }
            return mode[found].toString();
        }
    }

    public static enum OpMode {
        MANUAL(1),
        AUTO(2),
        SINGLE(3),
        REPEAT(4),
        EXT_GATE(5);

        private int setting;

        private OpMode(int setting) {
            this.setting = setting;
        }

        public int getSetting() {
            return this.setting;
        }

        public static String decode(String code) throws DriverException {
            OpMode[] mode = OpMode.values();
            int n = mode.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (mode[i].setting != Integer.parseInt(code)) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("ThorlabsSC10 invalid code for operating mode");
            }
            return mode[found].toString();
        }

        public static String listModes() {
            String list = "Shutter operating modes:";
            OpMode[] mode = OpMode.values();
            int n = mode.length;
            for (int i = 0; i < n; ++i) {
                list = list + "\n   " + mode[i].setting + " = " + (Object)((Object)mode[i]);
            }
            return list;
        }
    }

    public static enum CmndSC {
        IDENTIFIER("id", true, false),
        ENABLE("ens", true, false),
        REPEAT_COUNT("rep", true, true),
        OPERATING_MODE("mode", true, true),
        TRIGGER_MODE("trig", true, true),
        TRIG_OUT_MODE("xto", true, true),
        OPEN_DURATION("open", true, true),
        SHUT_DURATION("shut", true, true),
        CLOSED("closed", true, false),
        INTERLOCK("interlock", true, false),
        DATA_RATE("baud", true, true),
        SAVE("save", false, false),
        SAVE_TO_PROM("savp", false, false),
        LOAD_FROM_PROM("resp", false, false);

        private String command;
        private boolean queryAllowed;
        private boolean setAllowed;

        private CmndSC(String command, boolean queryAllowed, boolean setAllowed) {
            this.command = command;
            this.queryAllowed = queryAllowed;
            this.setAllowed = setAllowed;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

