/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;

public class TSConfigurable {
    private final Map<String, Integer> currentParms = new HashMap<String, Integer>();
    private int min;
    private int max;
    private double cryotol;
    @ConfigurationParameter(name="bias", category="TSConfig")
    private double biasVAcq;
    @ConfigurationParameter(name="cryo", category="TSConfig")
    private double cryoTAcq;
    @ConfigurationParameter(name="vac", category="TSConfig")
    private double vacPAcq;
    @ConfigurationParameter(name="lambda", category="TSConfig")
    private double lambdaAcq;
    @ConfigurationParameter(name="minlmppwr", category="TSConfig")
    private double minLmpPwr;
    @ConfigurationParameter(name="cryotol", category="TSConfig")
    private double cryoTAcqTol;
    final double MIN_BIAS = -70.0;
    final double MAX_BIAS = 0.0;
    final double MAX_CRYO = 30.0;

    public TSConfigurable(String name, double lambda, double minlmppwr, double cryotol, double bias, double vac, double cryo) {
        assert (bias > -70.0);
        assert (bias < 0.0);
        assert (cryo < 30.0);
        this.biasVAcq = bias;
        this.cryoTAcq = cryo;
        this.vacPAcq = vac;
        this.lambdaAcq = lambda;
        this.minLmpPwr = minlmppwr;
        this.cryoTAcqTol = cryotol;
    }

    @ConfigurationParameterChanger(propertyName="bias")
    public void setBiasVAcq(Object Vacq) {
        double bias = (Double)Vacq;
        assert (bias > -70.0);
        assert (bias < 0.0);
        System.out.println("configuring bias setpoint to " + bias);
        this.biasVAcq = bias;
    }

    @ConfigurationParameterChanger(propertyName="cryo")
    public void setCryoTAcq(Object temp) {
        double cryo = (Double)temp;
        assert (cryo < 30.0);
        System.out.println("configuring cryo temperature setpoint to " + cryo);
        this.cryoTAcq = (Double)temp;
    }

    @ConfigurationParameterChanger(propertyName="cryotol")
    public void setCryoTAcqTol(Object tempTol) {
        this.cryoTAcqTol = (Double)tempTol;
    }

    @ConfigurationParameterChanger(propertyName="vac")
    public void setVacPAcq(Object torr) {
        this.vacPAcq = (Double)torr;
    }

    @ConfigurationParameterChanger(propertyName="minlmppwr")
    public void setLmpPwr(Object LmpPwr) {
        this.minLmpPwr = (Double)LmpPwr;
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map map = (Map)currentParms;
        this.currentParms.putAll(map);
    }
}

