/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.thin;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueParser {
    private static final Pattern WORD = Pattern.compile("^\\s*(\\w+)");
    private static final Pattern NUMBER = Pattern.compile("^\\s*([eE+.\\-\\d]+)");
    private static final Pattern COMMA = Pattern.compile("^\\s*,");
    private static final Pattern EQUALS = Pattern.compile("^\\s*(=|:)");
    private static final Pattern UNITS = Pattern.compile("^\\s*(mm|deg|A|u)");
    private static final Pattern COMMENTARY = Pattern.compile("^([^,]+)");
    private static final Pattern EOI = Pattern.compile("^\\s*($)");

    public static Map<String, Double> parse(String tbReply) {
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        CharBuffer input = CharBuffer.wrap(tbReply);
        Matcher m = WORD.matcher(input);
        if (!m.find()) {
            throw new ParseError("Expected at least one key-value pair.", input.toString());
        }
        boolean morePairs = true;
        while (morePairs) {
            Kvp pair = ValueParser.keyValuePair(input);
            String key = String.join((CharSequence)" ", pair.key);
            result.put(key, pair.value);
            m = COMMA.matcher(input);
            if (m.find()) {
                ValueParser.consume(m, input);
                morePairs = true;
                continue;
            }
            morePairs = false;
        }
        m = EOI.matcher(input);
        if (!m.find()) {
            throw new ParseError("Expected end of line or whitespace.", input.toString());
        }
        return result;
    }

    private static Kvp keyValuePair(CharBuffer input) {
        List<String> words = ValueParser.wordList(input);
        Matcher m = EQUALS.matcher(input);
        if (!m.find()) {
            throw new ParseError("Expected an equals sign.", input.toString());
        }
        ValueParser.consume(m, input);
        double val = ValueParser.value(input);
        return new Kvp(words, val);
    }

    private static List<String> wordList(CharBuffer input) {
        LinkedList<String> result = new LinkedList<String>();
        Matcher m = WORD.matcher(input);
        boolean wordFound = m.find();
        if (!wordFound) {
            throw new ParseError("Expected one or more words.", input.toString());
        }
        while (wordFound) {
            result.add(m.group(1));
            ValueParser.consume(m, input);
            m = WORD.matcher(input);
            wordFound = m.find();
        }
        return result;
    }

    private static double value(CharBuffer input) {
        double result = 0.0;
        Matcher m = NUMBER.matcher(input);
        if (!m.find()) {
            throw new ParseError("Expected a decimal number.", input.toString());
        }
        try {
            result = Double.valueOf(m.group(1));
        }
        catch (NumberFormatException exc) {
            System.out.println(exc);
            throw new ParseError("Expected a decimal number.", input.toString());
        }
        ValueParser.consume(m, input);
        m = UNITS.matcher(input);
        if (m.find()) {
            ValueParser.consume(m, input);
        }
        if ((m = COMMENTARY.matcher(input)).find()) {
            ValueParser.consume(m, input);
        }
        return result;
    }

    private static void consume(Matcher m, CharBuffer input) {
        input.position(input.position() + m.group().length());
    }

    public static void main(String[] arg) {
        LinkedList<String> tests = new LinkedList<String>();
        tests.add("X=1.5, X2=1.3mm, Z=38 deg");
        tests.add("X=1.5e-1, X2=1.3E+2mm, Z=38. deg");
        tests.add("X =1.5,X2  =  1.3mm,    Z=    38 deg");
        tests.add("X=1.5, X2:1.3mm, Z=38 deg");
        tests.add("X=1.5, X2 : 1.3mm, Z=38 deg");
        tests.add("X=1.5, X2=1.3mm, Z=38 deg 8%");
        tests.add("x=22,");
        tests.add("");
        for (String t : tests) {
            try {
                System.out.println(t);
                Map<String, Double> result = ValueParser.parse(t);
                System.out.println(result);
            }
            catch (ParseError exc) {
                System.out.println(exc.getMessage());
            }
            System.out.println();
        }
    }

    public static class ParseError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseError(String errMsg, String remainingInput) {
            super(errMsg + " Input remaining: " + ParseError.truncate(remainingInput));
        }

        private static String truncate(String input) {
            if (input.length() <= 30) {
                return input;
            }
            return input.substring(0, 30) + " ...";
        }
    }

    private static class Kvp {
        public final List<String> key;
        public final double value;

        public Kvp(List<String> key, double value) {
            this.key = Collections.unmodifiableList(new ArrayList<String>(key));
            this.value = value;
        }
    }
}

