/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class Inclinometer
implements SensorPluggedOnDevice,
AlertRaiser,
HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(Inclinometer.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    private String name = "unset";
    @ConfigurationParameter(range="0..16", description="Inclinometer byte number", units="unitless", category="sensor")
    private volatile int byteNumero;
    @ConfigurationParameter(description="Inclinometer device name", units="unitless", category="sensor")
    private volatile String deviceName;
    private double voltage;
    private double inclinaison = 0.0;

    public void build() {
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.getName()), alwaysClear);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public void updateValue(int newValue) {
        FCSLOG.fine(() -> this.name + " updating inclinaison with newValue read on gateway (unit=0,1Volt): " + newValue);
        this.voltage = newValue;
        this.inclinaison = this.convertVoltage2Degree(this.voltage);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns inclinaison value in degrees. Doesn't read again CANopen device.")
    public double getInclinaison() {
        return this.inclinaison;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Raw voltage read on autochanger Pluto gateway in units of 0.1 Volts")
    public double getVoltage() {
        return this.voltage;
    }

    private double convertVoltage2Degree(double voltage) {
        double voltageInVolt = voltage / 10.0;
        double sin_angle = (voltageInVolt - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }
}

