/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bus;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.CapturedData;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;

public class BusMessagePrinter {
    private BusMessagePrinter() {
    }

    public static void main(String[] args) {
        System.out.println(new AxisStatus("X", false, true, false, true, false, Arrays.asList("fault1", "fault2"), 123.45));
        TreeMap<String, List<Double>> capMap = new TreeMap<String, List<Double>>();
        capMap.put("X", Arrays.asList(1.0, 2.0, 3.0));
        System.out.println(new CapturedData(capMap));
        System.out.println(new ChangeAxisEnable("X", true));
        System.out.println(new ChangeOutputLine(1, true));
        System.out.println(new ClearAllFaults());
        System.out.println(new ClearAxisFaults("X"));
        System.out.println(new ClearCapture());
        System.out.println(new ControllerStatus("UP", true, "OK"));
        System.out.println(new DisableAllAxes());
        System.out.println(new EnableAllAxes());
        System.out.println(new HomeAxis("X"));
        System.out.println(new IOStatus(165, 90, Arrays.asList(1.1, 2.1, 3.1)));
        System.out.println(new MoveAxisAbsolute("X", 123.45, 246.8));
        System.out.println(new MoveAxisRelative("X", 123.45, Duration.ofMillis(123L)));
        System.out.println(new SendAxisStatus("X"));
        System.out.println(new SendConfiguration());
        System.out.println(new SendControllerStatus());
        System.out.println(new SetupCapture(Arrays.asList("X"), Duration.ofMillis(123L), 100));
        System.out.println(new StopAllMotion());
    }
}

