/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.freehep.application.ProgressMeter;
import org.freehep.application.Stoppable;
import org.freehep.application.StoppableInputStream;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.web.JasView;
import org.freehep.jas.plugin.web.ReaderInputStream;
import org.freehep.jas.plugin.web.SimpleWebBrowser;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.HTMLEditorKitProvider;
import org.freehep.jas.services.ProgressMeterProvider;
import org.freehep.jas.services.TextEditorService;
import org.freehep.jas.services.URLHandler;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.template.TemplateEngine;
import org.openide.util.Lookup;

class HTMLPage
extends JPanel
implements HasPopupItems,
ManagedPage {
    private HTMLCommand htmlCommand = new HTMLCommand();
    private HTMLEditorPane jep;
    private HTMLEditorKit editorKit;
    private JScrollPane jsp;
    private PageContext pageContext;
    private SimpleWebBrowser plugin;
    private Studio app;
    private URL homePage;
    private URLHistory urlHistory;

    HTMLPage(URL homePage, Studio app, SimpleWebBrowser plugin) {
        super(new BorderLayout());
        this.homePage = homePage;
        this.plugin = plugin;
        this.app = app;
        HTMLEditorKitProvider hekp = (HTMLEditorKitProvider)app.getLookup().lookup(HTMLEditorKitProvider.class);
        if (hekp != null) {
            this.editorKit = hekp.getHTMLEditorKit();
            try {
                Method method = this.editorKit.getClass().getDeclaredMethod("setURL", URL.class);
                if (method != null) {
                    method.invoke((Object)this.editorKit, homePage);
                }
            }
            catch (Exception exception) {}
        } else {
            this.editorKit = new JASHTMLEditorKit();
        }
        this.jep = new HTMLEditorPane();
        this.jep.setEditable(false);
        this.jep.setMargin(new Insets(0, 0, 0, 0));
        this.jep.setEditorKitForContentType("text/html", this.editorKit);
        this.jep.setEditorKitForContentType("text/htm", this.editorKit);
        this.jsp = new JScrollPane(this.jep);
        this.add((Component)this.jsp, "Center");
        this.jep.addHyperlinkListener(new SimpleLinkListener());
        this.jep.addCaretListener(this.htmlCommand);
    }

    public CommandProcessor getCommandProcessor() {
        return this.htmlCommand;
    }

    public void setPageContext(PageContext context) {
        this.pageContext = context;
        this.urlHistory = new URLHistory(this.homePage);
        try {
            this.jep.setPage(this.homePage);
        }
        catch (Exception x) {
            this.app.error("Could not open home page", (Throwable)x);
        }
    }

    public boolean close() {
        return true;
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        this.app.getXMLMenuBuilder().mergePopupMenu("webPopupMenu", menu);
        JMenu history = new JMenu("History");
        history.setMnemonic('H');
        this.urlHistory.populateMenu(history);
        menu.add(history);
        return menu;
    }

    public void pageClosed() {
    }

    public void pageDeiconized() {
    }

    public void pageDeselected() {
        this.app.getCommandTargetManager().remove((CommandGroup)this.getCommandProcessor());
    }

    public void pageIconized() {
    }

    public void pageSelected() {
        this.app.getCommandTargetManager().add((CommandGroup)this.getCommandProcessor());
    }

    void showURL(URL url) {
        SwingUtilities.invokeLater(new PageLoader(url));
    }

    public class HTMLCommand
    extends CommandProcessor
    implements CaretListener {
        public void setChanged() {
            super.setChanged();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.setChanged();
        }

        public void enableBack(CommandState state) {
            state.setEnabled(HTMLPage.this.urlHistory.enableBack());
        }

        public void enableCopy(CommandState state) {
            state.setEnabled(HTMLPage.this.jep.getSelectedText() != null);
        }

        public void enableForward(CommandState state) {
            state.setEnabled(HTMLPage.this.urlHistory.enableForward());
        }

        public void enableViewSource(CommandState state) {
            state.setEnabled(HTMLPage.this.app.getLookup().lookup(TextEditorService.class) != null);
        }

        public void onBack() throws IOException {
            HTMLPage.this.urlHistory.goBack();
            this.setChanged();
        }

        public void onCopy() {
            HTMLPage.this.jep.copy();
        }

        public void onForward() throws IOException {
            HTMLPage.this.urlHistory.goForward();
            this.setChanged();
        }

        public void onRefresh() throws IOException {
            HTMLPage.this.urlHistory.reload();
        }

        public void onViewSource() {
            TextEditorService text = (TextEditorService)HTMLPage.this.app.getLookup().lookup(TextEditorService.class);
            text.show(HTMLPage.this.jep.getText(), "text/html", "HTML Source");
        }
    }

    private class HTMLEditorPane
    extends JEditorPane
    implements Runnable {
        private ProgressMeter meter;
        private ProgressMeterProvider pmp;
        private int requestedOffset;

        private HTMLEditorPane() {
            this.pmp = (ProgressMeterProvider)HTMLPage.this.app.getLookup().lookup(ProgressMeterProvider.class);
        }

        @Override
        public void paint(Graphics g) {
            if (HTMLPage.this.plugin.isAntiAlias() && g instanceof Graphics2D) {
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            super.paint(g);
        }

        @Override
        public void setPage(URL page) throws IOException {
            if (page == null) {
                throw new IOException("invalid url");
            }
            EditorKit kit = this.getEditorKit();
            try {
                Method method = kit.getClass().getDeclaredMethod("setURL", URL.class);
                if (method != null) {
                    method.invoke((Object)kit, page);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.setPage(page);
        }

        @Override
        public void run() {
            if (this.meter != null) {
                this.pmp.freeProgressMeter(this.meter);
                this.meter.setStoppable(null);
                this.meter = null;
            }
            if (this.requestedOffset != 0) {
                try {
                    Point p = this.modelToView(this.requestedOffset).getLocation();
                    if (p.y > 20) {
                        HTMLPage.this.jsp.getViewport().setViewPosition(p);
                    }
                }
                catch (BadLocationException p) {
                    // empty catch block
                }
                this.requestedOffset = 0;
            }
            Dictionary<Object, Object> dict = ((AbstractDocument)this.getDocument()).getDocumentProperties();
            String title = (String)dict.get("title");
            HTMLPage.this.pageContext.setTitle(title == null ? "Untitled" : title);
            if (title != null) {
                HTMLPage.this.urlHistory.recordTitle(title);
            }
        }

        @Override
        protected InputStream getStream(URL page) throws IOException {
            TemplateEngine engine;
            URLConnection conn = page.openConnection();
            StoppableInputStream sin = new StoppableInputStream(super.getStream(page), conn.getContentLength());
            if (this.pmp != null && this.meter == null) {
                this.meter = this.pmp.getProgressMeter();
                this.meter.setStoppable((Stoppable)sin);
            }
            if ((engine = HTMLPage.this.plugin.getTemplateEngine()) != null) {
                Reader reader = engine.filter((Reader)new InputStreamReader((InputStream)sin));
                return new ReaderInputStream(reader);
            }
            return sin;
        }

        @Override
        protected void firePropertyChange(String property, Object oldValue, Object newValue) {
            super.firePropertyChange(property, oldValue, newValue);
            if (property.equals("page")) {
                SwingUtilities.invokeLater(this);
            }
        }

        void setPage(URL url, int offset) throws IOException {
            this.requestedOffset = offset;
            this.setPage(url);
        }
    }

    private class URLHistory {
        private ListItem m_current;
        private ListItem m_root;

        URLHistory(URL root) {
            this.m_root = this.m_current = new ListItem(root);
        }

        boolean enableBack() {
            return this.m_current.prev != null;
        }

        boolean enableForward() {
            return this.m_current.next != null;
        }

        void goBack() throws IOException {
            this.m_current = this.m_current.prev;
            HTMLPage.this.jep.setPage(this.m_current.url, this.m_current.pos);
        }

        void goForward() throws IOException {
            this.m_current = this.m_current.next;
            HTMLPage.this.jep.setPage(this.m_current.url, this.m_current.pos);
        }

        void goTo(ListItem item) throws IOException {
            this.m_current = item;
            HTMLPage.this.jep.setPage(this.m_current.url, this.m_current.pos);
        }

        void populateMenu(JMenu history) {
            ListItem c = this.m_root;
            boolean enabled = false;
            while (c != null) {
                if (c != this.m_current) {
                    history.add(new HistoryItem(c));
                    enabled = true;
                }
                c = c.next;
            }
            history.setEnabled(enabled);
        }

        void recordPosition(int pos) {
            this.m_current.pos = pos;
        }

        void recordTitle(String title) {
            this.m_current.title = title;
        }

        void recordVisit(URL url) {
            if (this.m_current.next == null || !this.m_current.next.url.equals(url)) {
                this.clear(this.m_current.next);
                this.m_current.next = new ListItem(url);
                new ListItem(url).prev = this.m_current;
            }
            this.m_current = this.m_current.next;
        }

        void reload() throws IOException {
            HTMLPage.this.jep.getDocument().putProperty("stream", null);
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        private void clear(ListItem i) {
            if (i == null) {
                return;
            }
            this.clear(i.next);
            i.prev = null;
            i.next = null;
            i.url = null;
        }

        private class ListItem {
            ListItem next;
            ListItem prev;
            String title;
            URL url;
            int pos;

            ListItem(URL url) {
                this.url = url;
            }
        }

        private class HistoryItem
        extends JMenuItem {
            private ListItem item;

            HistoryItem(ListItem item) {
                super(item.title == null ? item.url.toExternalForm() : item.title);
                this.item = item;
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                try {
                    URLHistory.this.goTo(this.item);
                    HTMLPage.this.htmlCommand.setChanged();
                }
                catch (IOException x) {
                    HTMLPage.this.app.error("Could not open web page", (Throwable)x);
                }
                super.fireActionPerformed(e);
            }
        }
    }

    class JASHTMLEditorKit
    extends HTMLEditorKit {
        JASHTMLEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new JASHTMLFactory();
        }
    }

    private class SimpleLinkListener
    implements HyperlinkListener {
        private SimpleLinkListener() {
        }

        private Element findChild(Element parent, String name) {
            for (int i = 0; i < parent.getElementCount(); ++i) {
                Element child = parent.getElement(i);
                System.out.println("child.getName()=" + child.getName());
                if (!name.equals(child.getName())) continue;
                return child;
            }
            return null;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent he) {
            HyperlinkEvent.EventType type = he.getEventType();
            if (type == HyperlinkEvent.EventType.ENTERED) {
                URL url = he.getURL();
                if (url != null) {
                    HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(12));
                    HTMLPage.this.app.setStatusMessage(url.toString());
                }
            } else if (type == HyperlinkEvent.EventType.EXITED) {
                HTMLPage.this.jep.setCursor(Cursor.getDefaultCursor());
                HTMLPage.this.app.setStatusMessage(" ");
            } else if (he instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)he;
                HTMLDocument doc = (HTMLDocument)HTMLPage.this.jep.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                Object tag;
                AttributeSet as;
                URL url = he.getURL();
                Object target = null;
                Element element = he.getSourceElement();
                if (element != null && (as = element.getAttributes()) != null && (tag = as.getAttribute(HTML.Tag.A)) instanceof AttributeSet) {
                    target = ((AttributeSet)tag).getAttribute(HTML.Attribute.TARGET);
                }
                if ("_external".equals(target)) {
                    HTMLPage.this.plugin.showURL(url, true);
                } else {
                    try {
                        Lookup.Result result;
                        Lookup.Template template;
                        if (url.getProtocol().equals("file") && url.getHost().equals("") && !url.getFile().endsWith(".html")) {
                            template = new Lookup.Template(FileHandler.class);
                            result = HTMLPage.this.app.getLookup().lookup(template);
                            for (Object handler : result.allInstances()) {
                                File file;
                                if (!handler.accept(file = new File(url.getFile()))) continue;
                                handler.openFile(file);
                                return;
                            }
                        }
                        template = new Lookup.Template(URLHandler.class);
                        result = HTMLPage.this.app.getLookup().lookup(template);
                        for (Object handler : result.allInstances()) {
                            if (!handler.accept(url)) continue;
                            handler.openURL(url);
                            return;
                        }
                    }
                    catch (IOException x) {
                        HTMLPage.this.app.error("IO error while following link.", (Throwable)x);
                        return;
                    }
                    int pos = HTMLPage.this.jep.viewToModel(HTMLPage.this.jsp.getViewport().getViewPosition());
                    HTMLPage.this.urlHistory.recordPosition(pos);
                    HTMLPage.this.showURL(url);
                }
            }
        }
    }

    class PageLoader
    implements Runnable {
        private Cursor cursor;
        private URL url;

        PageLoader(URL u) {
            this.url = u;
            this.cursor = HTMLPage.this.jep.getCursor();
            HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public void run() {
            try {
                HTMLPage.this.jep.setPage(this.url);
                HTMLPage.this.urlHistory.recordVisit(this.url);
                HTMLPage.this.htmlCommand.setChanged();
            }
            catch (IOException x) {
                HTMLPage.this.app.error("Could not load page " + this.url, (Throwable)x);
            }
            finally {
                HTMLPage.this.jep.setCursor(this.cursor);
            }
        }
    }

    class JASHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        JASHTMLFactory() {
        }

        @Override
        public View create(Element elem) {
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o == HTML.Tag.OBJECT) {
                return new JasView(elem, HTMLPage.this.jep.getPage(), HTMLPage.this.app);
            }
            return super.create(elem);
        }
    }
}

