/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.RefrigControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.jas.CmprOptionalPage;

@Plugin(name="Compressor Control Plugin", description="Compressor Control Plugin")
public class CompressorPlugin
extends ConsolePlugin {
    public void initialize() {
        CmprOptionalPage optPage = new CmprOptionalPage("compressorType", RefrigControl.class, "hexType");
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class RefrigControl
    extends ControlPanel
    implements StatusMessageListener {
        private RefrigControlPanel ctrlPanel;

        RefrigControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RefrigState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(String agent) {
            this.ctrlPanel = new RefrigControlPanel(agent);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.ctrlPanel.initPanel();
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updatePanel((RefrigState)obj);
        }

        public void disableControlPanel() {
            this.ctrlPanel.disablePanel();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

