/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.MonitorTaskPanel;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.CompressorSummaryLine;

public class RefrigControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String SOLID_BAR = "\u2588";
    private static final String CMND_GET_STATE = "getSystemState";
    private final CommandSender sender;
    private boolean cmndError = false;
    private final JPanel compressorPanel = UiUtilities.newBorderedPanel((String)"Compressor Control");
    private final JPanel lightsPanel = UiUtilities.newBorderedPanel((String)"Cabinet Lights Control");
    private final JRadioButton[] lightsOnRB = new JRadioButton[2];
    private final JRadioButton[] lightsOffRB = new JRadioButton[2];
    private final ButtonGroup[] lightsBG = new ButtonGroup[2];
    private final JLabel[][] lightsState = new JLabel[3][2];
    private SystemStatusPanel statusPanel;
    private MonitorTaskPanel monTaskPanel;
    private int numColdPanels = 0;
    private int numCryoPanels = 0;
    private int numMonTasks = 0;
    private final CompressorSummaryLine[] coldLines = new CompressorSummaryLine[2];
    private final CompressorSummaryLine[] cryoLines = new CompressorSummaryLine[6];
    private final UiUtilities uiUtils;
    private static final long serialVersionUID = 1L;

    public RefrigControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        RefrigState rs = (RefrigState)reply;
        if (!this.cmndError) {
            if (this.numMonTasks > 0) {
                this.remove((Component)this.monTaskPanel);
            }
            this.monTaskPanel.initPanel(rs.getMonitorTasks());
            this.numMonTasks = rs.getNumMonTasks();
            if (this.numMonTasks > 0) {
                GridBagConstraints gbm = new GridBagConstraints();
                gbm.insets = new Insets(0, 0, 0, 0);
                gbm.anchor = 11;
                gbm.gridx = 0;
                gbm.gridy = 1;
                this.add((Component)this.monTaskPanel, gbm);
            }
            this.layoutCompressorPanel(rs.getNumColdComps(), rs.getNumCryoComps());
        }
        this.cmndError = false;
        this.updatePanel(rs);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.cmndError = true;
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int comp;
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.monTaskPanel = new MonitorTaskPanel("Monitor Task Control", this.sender, "MonitorControl");
        for (comp = 0; comp < this.coldLines.length; ++comp) {
            this.coldLines[comp] = new CompressorSummaryLine(0, this.sender);
        }
        for (comp = 0; comp < this.cryoLines.length; ++comp) {
            this.cryoLines[comp] = new CompressorSummaryLine(1, this.sender);
        }
        for (int cab = 0; cab < 2; ++cab) {
            for (int cmp = 0; cmp < 3; ++cmp) {
                this.lightsState[cmp][cab] = UiUtilities.newLabel((String)SOLID_BAR, (int)0);
                this.lightsState[cmp][cab].setForeground(Color.red);
            }
        }
        this.lightsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.insets = new Insets(4, 4, 4, 4);
        gbl.anchor = 17;
        gbl.gridx = 0;
        gbl.gridy = 0;
        for (int cab = 0; cab < 2; ++cab) {
            this.lightsOffRB[cab] = this.uiUtils.newRadioButton("Off", "F" + cab);
            this.lightsOnRB[cab] = this.uiUtils.newRadioButton("On", "N" + cab);
            this.lightsBG[cab] = new ButtonGroup();
            this.lightsBG[cab].add(this.lightsOffRB[cab]);
            this.lightsBG[cab].add(this.lightsOnRB[cab]);
            this.lightsPanel.add((Component)UiUtilities.newLabel((String)("Cabinet " + cab + ":"), (int)0), gbl);
            ++gbl.gridx;
            gbl.insets.left = 0;
            this.lightsPanel.add((Component)this.lightsOffRB[cab], gbl);
            ++gbl.gridx;
            this.lightsPanel.add((Component)this.lightsOnRB[cab], gbl);
            ++gbl.gridx;
            gbl.insets.left = 4;
            for (int cmp = 0; cmp < 3; ++cmp) {
                gbl.insets.right = cmp < 2 ? 0 : 4;
                this.lightsPanel.add((Component)this.lightsState[cmp][cab], gbl);
                ++gbl.gridx;
                gbl.insets.left = 0;
            }
            gbl.insets.left = 30;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 4, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.statusPanel, gbm);
        gbm.gridy += 2;
        this.add((Component)this.compressorPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.lightsPanel, gbm);
    }

    private void layoutCompressorPanel(int numColdComps, int numCryoComps) {
        int j;
        int j2;
        for (j2 = 0; j2 < this.numColdPanels; ++j2) {
            this.compressorPanel.remove(this.coldLines[j2]);
        }
        for (j2 = 0; j2 < this.numCryoPanels; ++j2) {
            this.compressorPanel.remove(this.cryoLines[j2]);
        }
        this.numColdPanels = numColdComps;
        this.numCryoPanels = numCryoComps;
        this.compressorPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        for (j = 0; j < this.numColdPanels; ++j) {
            gbm.insets.bottom = j == this.numColdPanels + this.numCryoPanels - 1 ? 4 : 0;
            this.compressorPanel.add((Component)this.coldLines[j], gbm);
            ++gbm.gridy;
        }
        for (j = 0; j < this.numCryoPanels; ++j) {
            gbm.insets.bottom = j == this.numCryoPanels - 1 ? 4 : 0;
            this.compressorPanel.add((Component)this.cryoLines[j], gbm);
            ++gbm.gridy;
        }
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        int cab = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(null, "switchLights", new Object[]{cab, action == 'N'});
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.disablePanel();
            RefrigControlPanel.this.monTaskPanel.disablePanel();
            for (CompressorSummaryLine comp : RefrigControlPanel.this.coldLines) {
                comp.disableSystem();
            }
            for (CompressorSummaryLine comp : RefrigControlPanel.this.cryoLines) {
                comp.disableSystem();
            }
            for (int cab = 0; cab < 2; ++cab) {
                RefrigControlPanel.this.lightsOffRB[cab].setEnabled(false);
                RefrigControlPanel.this.lightsOnRB[cab].setEnabled(false);
                for (int cmp = 0; cmp < 3; ++cmp) {
                    RefrigControlPanel.this.lightsState[cmp][cab].setEnabled(false);
                }
            }
            RefrigControlPanel.this.repaint();
        }
    }

    class UpdateRefrigState
    implements Runnable {
        private final RefrigState rs;

        UpdateRefrigState(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.updatePanel(this.rs.getTickMillis());
            RefrigControlPanel.this.monTaskPanel.updatePanel(this.rs.getMonitorTasks());
            for (CompState cs : this.rs.getColdStates()) {
                RefrigControlPanel.this.coldLines[cs.getIndex()].updateControlPanel(cs);
            }
            for (CompState cs : this.rs.getCryoStates()) {
                RefrigControlPanel.this.cryoLines[cs.getIndex()].updateControlPanel(cs);
            }
            for (int cab = 0; cab < 2; ++cab) {
                boolean on = false;
                for (int cmp = 0; cmp < 3; ++cmp) {
                    SwitchState state = this.rs.getLightState(cab, cmp);
                    RefrigControlPanel.this.lightsState[cmp][cab].setEnabled(true);
                    RefrigControlPanel.this.lightsState[cmp][cab].setForeground(state == SwitchState.OFF ? Color.BLACK : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE));
                    on |= state == SwitchState.ON;
                }
                JRadioButton selButton = on ? RefrigControlPanel.this.lightsOnRB[cab] : RefrigControlPanel.this.lightsOffRB[cab];
                selButton.setSelected(true);
                RefrigControlPanel.this.lightsOffRB[cab].setEnabled(true);
                RefrigControlPanel.this.lightsOnRB[cab].setEnabled(true);
            }
            RefrigControlPanel.this.repaint();
        }
    }
}

