/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.services.persist.Savable;

public class Trend
implements Savable {
    private final Descriptor descriptor;
    private TrendPlotter plotter;
    private TrendData data;
    private long timestamp;
    private boolean loading;
    private volatile String type;
    private volatile String[] values;

    public Trend(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public synchronized Descriptor getDescriptor() {
        return this.descriptor;
    }

    public synchronized TrendPlotter getPlotter() {
        return this.plotter;
    }

    synchronized void setPlotter(TrendPlotter plotter) {
        this.plotter = plotter;
    }

    public synchronized TrendData getData() {
        return this.data;
    }

    public synchronized void setData(TrendData data) {
        this.data = data;
        this.timestamp = System.currentTimeMillis();
        this.loading = false;
        if (this.plotter != null) {
            TrendPlotter p = this.plotter;
            SwingUtilities.invokeLater(() -> p.onDataChange(this));
        }
    }

    public synchronized TimeWindow getTimeWindow() {
        return this.plotter == null ? null : this.plotter.getTimeWindow();
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized long[] getTimeRange() {
        if (this.data == null) {
            TimeWindow timeWindow = this.getTimeWindow();
            if (timeWindow == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            return new long[]{timeWindow.getLowerEdge(now), timeWindow.getUpperEdge(now)};
        }
        return this.data.getTimeRange();
    }

    public synchronized boolean setLoading(boolean value) {
        boolean out;
        boolean bl = out = value != this.loading;
        if (!this.loading && value) {
            this.timestamp = System.currentTimeMillis();
            this.loading = true;
            if (this.plotter != null) {
                TrendPlotter p = this.plotter;
                SwingUtilities.invokeLater(() -> p.onRefreshRequest(this));
            }
        }
        this.loading = value;
        return out;
    }

    public synchronized boolean isLoading() {
        return this.loading;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    @Override
    public synchronized Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private String path;
        private String displayPath;

        public Descriptor() {
        }

        public Descriptor(String path) {
            this.path = path;
        }

        public Descriptor(String path, String displayPath) {
            this.path = path;
            this.displayPath = displayPath;
        }

        public Descriptor(Descriptor other) {
            this.path = other.path;
            this.displayPath = other.displayPath;
        }

        public String getDisplayPath() {
            return this.displayPath == null ? this.path : this.displayPath;
        }

        public void setDisplayPath(String displayPath) {
            this.displayPath = displayPath;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Transient
        public String getTitle() {
            String s = this.getDisplayPath();
            return s;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[TD: ");
            if (this.displayPath != null) {
                sb.append(this.displayPath).append(" --> ");
            }
            sb.append(this.path);
            sb.append("]");
            return sb.toString();
        }

        public Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException(x);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Descriptor) {
                Descriptor d = (Descriptor)obj;
                return Objects.equals(this.path, d.path) && Objects.equals(this.displayPath, d.displayPath);
            }
            return false;
        }

        public int hashCode() {
            return (this.path + (this.displayPath == null ? "" : this.displayPath)).hashCode();
        }
    }
}

