/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.MutedAlertRequest;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.alert.MuteDialog;

public final class MuteListDialog
extends JDialog {
    private final TreeMap<String, TreeMap<String, MutedAlertRequest>> muteRequests;
    private final JComboBox<String> agentCombo = new JComboBox();
    private final JTable table = new JTable(new Model());
    private final JButton deleteButton = new JButton("Delete");
    private String selectedAgent;
    private MutedAlertRequest selectedRequest;
    private List<MutedAlertRequest> requests;
    private String[] agents;

    MuteListDialog(Component parent, TreeMap<String, TreeMap<String, MutedAlertRequest>> muteRequests, String agentSeed, String regExSeed) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), "Muted alerts", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MuteListDialog.this.dispose();
            }
        });
        this.muteRequests = muteRequests;
        this.selectedAgent = agentSeed;
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        box.add(new JLabel("Subsystem:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.agentCombo.addActionListener(e -> {
            int prevRows = this.table.getModel().getRowCount();
            int i = this.agentCombo.getSelectedIndex();
            if (i == -1) {
                this.selectedAgent = null;
                this.requests = Collections.emptyList();
            } else {
                this.selectedAgent = this.agents[i];
                this.requests = new ArrayList(((TreeMap)muteRequests.get(this.selectedAgent)).values());
            }
            int currentRows = this.table.getModel().getRowCount();
            if (currentRows > prevRows) {
                if (prevRows > 0) {
                    ((Model)this.table.getModel()).fireTableRowsUpdated(0, prevRows - 1);
                }
                ((Model)this.table.getModel()).fireTableRowsInserted(prevRows, currentRows - 1);
            } else if (currentRows < prevRows) {
                if (currentRows > 0) {
                    ((Model)this.table.getModel()).fireTableRowsUpdated(0, currentRows - 1);
                }
                ((Model)this.table.getModel()).fireTableRowsDeleted(currentRows, prevRows - 1);
            } else if (currentRows > 0) {
                ((Model)this.table.getModel()).fireTableRowsUpdated(0, currentRows - 1);
            }
        });
        box.add(this.agentCombo);
        this.add((Component)box, "North");
        for (int i = 0; i < 3; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            int min = new JLabel((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001      "}, (String)column.getHeaderValue().toString()))).getPreferredSize().width;
            column.setPreferredWidth(switch (i) {
                case 0 -> min * 3;
                case 1 -> min;
                default -> min * 2;
            });
            column.setMinWidth(min);
            if (i != 1) continue;
            DefaultCellRenderer r = new DefaultCellRenderer();
            r.setHorizontalAlignment(0);
            column.setCellRenderer((TableCellRenderer)r);
        }
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow == -1) {
                this.selectedRequest = null;
                this.deleteButton.setEnabled(false);
            } else {
                this.selectedRequest = this.requests.get(selectedRow);
                this.deleteButton.setEnabled(true);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        JButton button = new JButton("New");
        button.addActionListener(e -> MuteDialog.show(this, agentSeed, regExSeed));
        buttonBox.add(button);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(e -> {
            if (this.selectedAgent != null && this.selectedRequest != null) {
                AlertViewer.sendCommandToMMM("cancelMutedAlertRequest", this.selectedRequest.getUniqueId());
            }
        });
        buttonBox.add(this.deleteButton);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        JButton cancelButton = new JButton("Dismiss");
        cancelButton.addActionListener(e -> this.dispose());
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        this.add((Component)buttonBox, "South");
        this.update();
    }

    void update() {
        if (this.muteRequests.isEmpty()) {
            this.agents = new String[0];
            this.selectedAgent = null;
            this.requests = Collections.emptyList();
        } else {
            ArrayList<String> agentNames = new ArrayList<String>(this.muteRequests.keySet());
            this.agents = agentNames.toArray(new String[0]);
            int i = agentNames.indexOf(this.selectedAgent);
            if (i == -1) {
                i = 0;
                this.selectedAgent = this.agents[0];
            }
            this.requests = new ArrayList<MutedAlertRequest>(this.muteRequests.get(this.selectedAgent).values());
        }
        this.agentCombo.setModel(new DefaultComboBoxModel<String>(this.agents));
        this.agentCombo.setEnabled(this.agents.length > 0);
        this.agentCombo.revalidate();
        this.agentCombo.repaint();
        if (this.selectedAgent != null) {
            this.agentCombo.setSelectedItem(this.selectedAgent);
        }
        this.revalidate();
        this.repaint();
    }

    static MuteListDialog show(Component parent, TreeMap<String, TreeMap<String, MutedAlertRequest>> muteRequests, String agentSeed, String regExSeed) {
        MuteListDialog d = new MuteListDialog(parent, muteRequests, agentSeed, regExSeed);
        d.setSize(d.getPreferredSize());
        d.pack();
        d.setLocationRelativeTo(parent);
        return d;
    }

    private class Model
    extends DefaultTableModel {
        private Model() {
        }

        @Override
        public int getRowCount() {
            return MuteListDialog.this.requests == null ? 0 : MuteListDialog.this.requests.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            MutedAlertRequest r = MuteListDialog.this.requests.get(row);
            return switch (column) {
                case 0 -> r.getAlertIdRegEx();
                case 1 -> (r.getExpirationMillis() - System.currentTimeMillis()) / 60000L;
                case 2 -> r.getUserName();
                default -> throw new IllegalArgumentException();
            };
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> "Regular expression";
                case 1 -> "Minutes left";
                case 2 -> "Muted by";
                default -> throw new IllegalArgumentException();
            };
        }
    }
}

