/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;

public class AckDialog
extends JDialog {
    private final JTextArea messageArea;
    private final Table tableOfAlerts;
    private final List<RaisedAlertHistory> alerts;
    private final JButton ackButton;
    String message;
    String[] alertsToAck;
    String[] alertsToNack;

    private AckDialog(AlertViewer.AlertNode node, Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Acknowledge alerts", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AckDialog.this.message = null;
                AckDialog.this.dispose();
            }
        });
        TreeMap aa = new TreeMap();
        node.getLeaves().stream().map(n -> n.getHistory()).forEach(h -> aa.put(h.getHighestAlert().getAlertId(), h));
        this.alerts = new ArrayList(aa.values());
        Box infoBox = Box.createVerticalBox();
        infoBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel label = new JLabel("<html>Acknowledging an alert informs operators that the issue is being taken care of.");
        label.setAlignmentX(0.0f);
        infoBox.add(label);
        infoBox.add(Box.createRigidArea(Const.VDIM));
        label = new JLabel("<html>Subsystem: <b>" + node.getAgentName());
        label.setAlignmentX(0.0f);
        infoBox.add(label);
        this.tableOfAlerts = new Table();
        JScrollPane sp = new JScrollPane(this.tableOfAlerts);
        sp.setAlignmentX(0.0f);
        infoBox.add(sp);
        infoBox.add(Box.createRigidArea(Const.VDIM));
        this.add((Component)infoBox, "North");
        Box messageBox = Box.createVerticalBox();
        messageBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        label = new JLabel("<html><b>Message:");
        label.setAlignmentX(0.0f);
        messageBox.add(label);
        this.messageArea = new JTextArea(4, 80);
        this.messageArea.setAlignmentX(0.0f);
        messageBox.add(this.messageArea);
        this.add((Component)messageBox, "Center");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        buttonBox.add(Box.createHorizontalGlue());
        this.ackButton = new JButton("Commit");
        this.ackButton.addActionListener(e -> {
            this.message = this.messageArea.getText();
            if (this.message.length() > 300) {
                this.message = this.message.substring(0, 300) + " ...";
            }
            ((TableModel)this.tableOfAlerts.getModel()).fillIDs();
            this.dispose();
        });
        buttonBox.add(this.ackButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.message = null;
            this.dispose();
        });
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        this.add((Component)buttonBox, "South");
    }

    static AckDialog show(AlertViewer.AlertNode node, Component parentComponent) {
        if (parentComponent != null) {
            parentComponent = SwingUtilities.getWindowAncestor(parentComponent);
        }
        AckDialog d = new AckDialog(node, parentComponent);
        d.setSize(d.getPreferredSize());
        d.pack();
        d.setLocationRelativeTo(parentComponent);
        d.setVisible(true);
        return d.message == null ? null : d;
    }

    private class Table
    extends JTable {
        Table() {
            this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof RaisedAlertHistory) {
                        RaisedAlertHistory h = (RaisedAlertHistory)value;
                        AlertState high = h.getHighestAlertState();
                        switch (column) {
                            case 1: {
                                this.setText(h.getHighestAlert().getAlertId());
                                this.setForeground(null);
                                this.setToolTipText(h.getHighestAlert().getDescription());
                                break;
                            }
                            case 2: {
                                this.setText(high.toString());
                                this.setForeground(LsstAlertPlugin.COLOR.get(high));
                                this.setToolTipText(h.getLatestAlertCause());
                            }
                        }
                    }
                    return this;
                }
            });
            this.setModel(new TableModel());
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(false);
            for (int i = 0; i < 3; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(switch (i) {
                    case 0 -> new JLabel((String)" Acknowledged ").getPreferredSize().width;
                    default -> 400;
                });
            }
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private boolean[] ack;

        TableModel() {
            this.ack = new boolean[AckDialog.this.alerts.size()];
            for (int i = 0; i < this.ack.length; ++i) {
                this.ack[i] = AckDialog.this.alerts.get(i).isAcknowledged();
            }
        }

        void fillIDs() {
            ArrayList<String> toAck = new ArrayList<String>(AckDialog.this.alerts.size());
            ArrayList<String> toNack = new ArrayList<String>(AckDialog.this.alerts.size());
            boolean reAck = false;
            for (int i = 0; i < this.ack.length; ++i) {
                if (this.ack[i]) {
                    if (!reAck && AckDialog.this.alerts.get(i).isAcknowledged()) continue;
                    toAck.add(AckDialog.this.alerts.get(i).getHighestAlert().getAlertId());
                    continue;
                }
                if (!AckDialog.this.alerts.get(i).isAcknowledged()) continue;
                toNack.add(AckDialog.this.alerts.get(i).getHighestAlert().getAlertId());
            }
            AckDialog.this.alertsToAck = toAck.toArray(new String[0]);
            AckDialog.this.alertsToNack = toNack.toArray(new String[0]);
        }

        @Override
        public int getRowCount() {
            return AckDialog.this.alerts.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> this.ack[rowIndex];
                default -> AckDialog.this.alerts.get(rowIndex);
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.ack[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> "Acknowledged";
                case 1 -> "Alert ID";
                case 2 -> "Max severity";
                default -> throw new IllegalArgumentException();
            };
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> Boolean.class;
                default -> String.class;
            };
        }
    }
}

