/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.jas.plugin.tree.DefaultFTree;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeSorter;
import org.freehep.jas.plugin.tree.FTreeNodeSorterManager;
import org.freehep.jas.plugin.tree.FTreePlugin;

class FTreeSortingChooser
extends JPanel {
    private String sortingString;
    private SortedListModel availableListModel;
    private SortedListModel selectedListModel;
    private FTreePlugin thePlugin = FTreePlugin.plugin();
    private DefaultFTree tree;
    private String allTreeString = "All trees";
    private String[] treeNames;
    private JDialog dlg;
    private JButton addButton;
    private JButton applyButton;
    private JPanel applyPanel;
    private JLabel applyText;
    private JList availableList;
    private JScrollPane availableListScrollPane;
    private JLabel availableText;
    private JButton cancelButton;
    private JButton downButton;
    private JPanel exitPanel;
    private JCheckBox foldersCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel listButtonsPanel;
    private JPanel mainSelectionPanel;
    private JButton okButton;
    private JCheckBox recursiveCheckBox;
    private JButton removeButton;
    private JList selectedList;
    private JScrollPane selectedListScrollPane;
    private JLabel selectedText;
    private JPanel sortingLists;
    private JPanel sortingSelectionPanel;
    private JLabel title;
    private JCheckBox treeCheckBox;
    private JComboBox treeComboBox;
    private JButton upButton;

    public FTreeSortingChooser(JDialog dlg) {
        this(null, null, dlg);
    }

    public FTreeSortingChooser(DefaultFTree tree, String sortingString, JDialog dlg) {
        this.dlg = dlg;
        this.initComponents();
        this.initPanel(tree, sortingString);
    }

    private void initPanel(DefaultFTree tree, String sortingString) {
        this.sortingString = sortingString;
        this.tree = tree;
        ArrayList trees = this.thePlugin.trees();
        int size = trees.size();
        if (size == 1) {
            this.jPanel2.remove(this.treeComboBox);
            this.treeNames = new String[size];
            this.treeNames[0] = ((DefaultFTree)trees.get(0)).name();
            if (tree == null) {
                tree = (DefaultFTree)trees.get(0);
            }
        } else {
            this.treeNames = new String[++size];
            this.treeNames[0] = this.allTreeString;
            for (int i = 0; i < trees.size(); ++i) {
                this.treeNames[i + 1] = ((DefaultFTree)trees.get(i)).name();
            }
            this.treeComboBox.setModel(new DefaultComboBoxModel<String>(this.treeNames));
            if (tree != null) {
                this.treeComboBox.setSelectedItem(tree.name());
            }
            this.treeCheckBox.setText(this.treeCheckBox.getText() + " for tree");
        }
        this.foldersCheckBox.setSelected(false);
        if (tree.selectedNodes() == null) {
            this.foldersCheckBox.setEnabled(false);
        } else {
            FTreeNode[] nodes = tree.selectedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                DefaultFTreeNode node = (DefaultFTreeNode)nodes[i];
                if (!node.getAllowsChildren()) continue;
                this.foldersCheckBox.setSelected(true);
                break;
            }
        }
        this.treeCheckBox.setSelected(!this.foldersCheckBox.isSelected());
        if (sortingString == null) {
            sortingString = ((DefaultFTreeNode)tree.root()).sortingString();
        }
        Collection availableSorters = FTreeNodeSorterManager.availableSorters();
        Collection selectedSorters = FTreeNodeSorterManager.sortingComparator(sortingString).sorters();
        this.availableListModel = new SortedListModel(availableSorters, selectedSorters);
        this.availableList.setModel(this.availableListModel);
        this.availableList.setAutoscrolls(true);
        this.selectedListModel = new SortedListModel(selectedSorters);
        this.selectedList.setModel(this.selectedListModel);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.recursiveCheckBox.setSelected(true);
    }

    private void updateToolTipsText(String selectedSorter, JList list) {
        String toolTipsText = "";
        if (selectedSorter != null) {
            Collection availableSorters = FTreeNodeSorterManager.availableSorters();
            for (FTreeNodeSorter sorter : availableSorters) {
                if (!sorter.algorithmName().equals(selectedSorter)) continue;
                toolTipsText = sorter.description();
                break;
            }
        }
        list.setToolTipText(toolTipsText);
    }

    private void updateButtons() {
        int selectedIndex = this.availableList.getSelectedIndex();
        this.addButton.setEnabled(selectedIndex != -1);
        selectedIndex = this.selectedList.getSelectedIndex();
        this.removeButton.setEnabled(((SortedListModel)this.selectedList.getModel()).getSize() > 1 && selectedIndex != -1);
        this.upButton.setEnabled(selectedIndex != -1 && this.selectedListModel.getSize() > 1 && selectedIndex > 0);
        this.downButton.setEnabled(selectedIndex != -1 && this.selectedListModel.getSize() > 1 && selectedIndex < this.selectedListModel.getSize() - 1);
    }

    private void clearSelection() {
        this.selectedList.clearSelection();
        this.availableList.clearSelection();
        this.updateButtons();
    }

    void apply() {
        String sortingString = FTreeNodeSorterManager.sortingString(((SortedListModel)this.selectedList.getModel()).list());
        boolean recursively = this.recursiveCheckBox.isSelected();
        if (this.foldersCheckBox.isSelected()) {
            FTreeNode[] nodes = this.tree.selectedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                DefaultFTreeNode node = (DefaultFTreeNode)nodes[i];
                if (!node.getAllowsChildren()) continue;
                node.applySorting(sortingString, recursively);
            }
        }
        if (this.treeCheckBox.isSelected()) {
            String[] selectedTreeNames;
            String selectedTree = (String)this.treeComboBox.getSelectedItem();
            if (selectedTree != null && selectedTree.equals(this.allTreeString)) {
                selectedTreeNames = new String[this.treeNames.length - 1];
                for (int i = 0; i < selectedTreeNames.length; ++i) {
                    selectedTreeNames[i] = this.treeNames[i + 1];
                }
            } else {
                selectedTreeNames = new String[]{this.treeNames[0]};
            }
            for (int i = 0; i < selectedTreeNames.length; ++i) {
                DefaultFTree tree = (DefaultFTree)this.thePlugin.tree(selectedTreeNames[i]);
                DefaultFTreeNode root = (DefaultFTreeNode)tree.root();
                root.applySorting(sortingString, recursively);
                this.thePlugin.setTreeSortingAlgorithm(selectedTreeNames[i], sortingString);
                this.thePlugin.setIsTreeSortingRecursive(selectedTreeNames[i], recursively);
            }
        }
    }

    private void initComponents() {
        this.title = new JLabel();
        this.mainSelectionPanel = new JPanel();
        this.applyPanel = new JPanel();
        this.applyText = new JLabel();
        this.recursiveCheckBox = new JCheckBox();
        this.foldersCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.treeCheckBox = new JCheckBox();
        this.treeComboBox = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.sortingSelectionPanel = new JPanel();
        this.sortingLists = new JPanel();
        this.selectedText = new JLabel();
        this.availableText = new JLabel();
        this.availableListScrollPane = new JScrollPane();
        this.availableList = new JList();
        this.selectedListScrollPane = new JScrollPane();
        this.selectedList = new JList();
        this.listButtonsPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.exitPanel = new JPanel();
        this.cancelButton = new JButton();
        this.applyButton = new JButton();
        this.okButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.title.setFont(new Font("Dialog", 0, 14));
        this.title.setText("Choose the combination of sorting algorithms");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 4);
        this.add((Component)this.title, gridBagConstraints);
        this.mainSelectionPanel.setLayout(new GridBagLayout());
        this.mainSelectionPanel.setBorder(new EtchedBorder(Color.lightGray, null));
        this.applyPanel.setLayout(new GridBagLayout());
        this.applyText.setFont(new Font("Dialog", 0, 14));
        this.applyText.setText("Apply to:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.applyPanel.add((Component)this.applyText, gridBagConstraints);
        this.recursiveCheckBox.setFont(new Font("Dialog", 0, 14));
        this.recursiveCheckBox.setText("recursively");
        this.recursiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.recursiveCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.applyPanel.add((Component)this.recursiveCheckBox, gridBagConstraints);
        this.foldersCheckBox.setFont(new Font("Dialog", 0, 14));
        this.foldersCheckBox.setText("selected folders");
        this.foldersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.foldersCheckBoxActionPerformed(evt);
            }
        });
        this.foldersCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FTreeSortingChooser.this.foldersCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.applyPanel.add((Component)this.foldersCheckBox, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.treeCheckBox.setFont(new Font("Dialog", 0, 14));
        this.treeCheckBox.setText("root node");
        this.treeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.treeCheckBoxActionPerformed(evt);
            }
        });
        this.treeCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FTreeSortingChooser.this.treeCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.treeCheckBox, gridBagConstraints);
        this.treeComboBox.setFont(new Font("Dialog", 0, 12));
        this.jPanel2.add((Component)this.treeComboBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.applyPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.applyPanel.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 4, 0, 0);
        this.mainSelectionPanel.add((Component)this.applyPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.sortingSelectionPanel.setLayout(new GridBagLayout());
        this.sortingLists.setLayout(new GridBagLayout());
        this.selectedText.setFont(new Font("Dialog", 0, 14));
        this.selectedText.setText("Selected list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.sortingLists.add((Component)this.selectedText, gridBagConstraints);
        this.availableText.setFont(new Font("Dialog", 0, 14));
        this.availableText.setText("Available");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.sortingLists.add((Component)this.availableText, gridBagConstraints);
        this.availableListScrollPane.setPreferredSize(new Dimension(134, 100));
        this.availableList.setBorder(new EtchedBorder(Color.darkGray, Color.lightGray));
        this.availableList.setFont(new Font("Dialog", 0, 14));
        this.availableList.setSelectionMode(0);
        this.availableList.setPreferredSize(null);
        this.availableList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FTreeSortingChooser.this.availableListFocusGained(evt);
            }
        });
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FTreeSortingChooser.this.availableListValueChanged(evt);
            }
        });
        this.availableListScrollPane.setViewportView(this.availableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.sortingLists.add((Component)this.availableListScrollPane, gridBagConstraints);
        this.selectedListScrollPane.setPreferredSize(new Dimension(134, 100));
        this.selectedList.setBorder(new EtchedBorder(Color.darkGray, null));
        this.selectedList.setFont(new Font("Dialog", 0, 14));
        this.selectedList.setSelectionMode(0);
        this.selectedList.setPreferredSize(null);
        this.selectedList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FTreeSortingChooser.this.selectedListFocusGained(evt);
            }
        });
        this.selectedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FTreeSortingChooser.this.selectedListValueChanged(evt);
            }
        });
        this.selectedListScrollPane.setViewportView(this.selectedList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.sortingLists.add((Component)this.selectedListScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.sortingSelectionPanel.add((Component)this.sortingLists, gridBagConstraints);
        this.listButtonsPanel.setLayout(new GridBagLayout());
        this.addButton.setFont(new Font("Dialog", 0, 12));
        this.addButton.setText("Add");
        this.addButton.setPreferredSize(new Dimension(80, 26));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.listButtonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setFont(new Font("Dialog", 0, 12));
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.listButtonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setFont(new Font("Dialog", 0, 12));
        this.upButton.setText("Up");
        this.upButton.setPreferredSize(new Dimension(80, 26));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.listButtonsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setFont(new Font("Dialog", 0, 12));
        this.downButton.setText("Down");
        this.downButton.setPreferredSize(new Dimension(80, 26));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.listButtonsPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.sortingSelectionPanel.add((Component)this.listButtonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel1.add((Component)this.sortingSelectionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.mainSelectionPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainSelectionPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 3, 4);
        this.add((Component)this.mainSelectionPanel, gridBagConstraints);
        this.exitPanel.setLayout(new GridBagLayout());
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.exitPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.applyButton.setFont(new Font("Dialog", 0, 12));
        this.applyButton.setText("Apply");
        this.applyButton.setPreferredSize(new Dimension(73, 26));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.applyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.exitPanel.add((Component)this.applyButton, gridBagConstraints);
        this.okButton.setFont(new Font("Dialog", 0, 12));
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(73, 26));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTreeSortingChooser.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.exitPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.exitPanel, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.apply();
        this.setVisible(false);
        this.dlg.setVisible(false);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.apply();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dlg.setVisible(false);
    }

    private void foldersCheckBoxMouseClicked(MouseEvent evt) {
        this.foldersCheckBox.setSelected(true);
    }

    private void treeCheckBoxMouseClicked(MouseEvent evt) {
        this.treeCheckBox.setSelected(true);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.selectedList.getSelectedIndex();
        this.selectedListModel.move(i, i + 1);
        this.selectedList.updateUI();
        this.clearSelection();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.selectedList.getSelectedIndex();
        this.selectedListModel.move(i, i - 1);
        this.selectedList.updateUI();
        this.clearSelection();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int i = this.selectedList.getSelectedIndex();
        Object o = this.selectedListModel.get(i);
        this.selectedListModel.remove(i);
        this.availableListModel.add(o);
        this.selectedList.updateUI();
        this.availableList.updateUI();
        this.clearSelection();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int i = this.availableList.getSelectedIndex();
        Object o = this.availableListModel.get(i);
        this.availableListModel.remove(i);
        this.selectedListModel.add(o);
        this.availableList.updateUI();
        this.selectedList.updateUI();
        this.clearSelection();
    }

    private void recursiveCheckBoxActionPerformed(ActionEvent evt) {
        this.clearSelection();
    }

    private void foldersCheckBoxActionPerformed(ActionEvent evt) {
        this.clearSelection();
        this.treeCheckBox.setSelected(false);
    }

    private void treeCheckBoxActionPerformed(ActionEvent evt) {
        this.clearSelection();
        this.foldersCheckBox.setSelected(false);
    }

    private void selectedListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
        this.updateToolTipsText((String)this.selectedList.getSelectedValue(), this.selectedList);
    }

    private void availableListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
        this.updateToolTipsText((String)this.availableList.getSelectedValue(), this.availableList);
    }

    private void selectedListFocusGained(FocusEvent evt) {
        this.availableList.clearSelection();
    }

    private void availableListFocusGained(FocusEvent evt) {
        this.selectedList.clearSelection();
    }

    private class SortedListModel
    extends AbstractListModel {
        private ArrayList s = new ArrayList();

        SortedListModel(Collection sorters, Collection sorters1) {
            Iterator iter;
            if (sorters != null) {
                iter = sorters.iterator();
                while (iter.hasNext()) {
                    this.s.add(iter.next());
                }
            }
            if (sorters1 != null) {
                iter = sorters1.iterator();
                while (iter.hasNext()) {
                    this.s.remove(iter.next());
                }
            }
        }

        SortedListModel(Collection sorters) {
            this(sorters, null);
        }

        @Override
        public int getSize() {
            return this.s.size();
        }

        @Override
        public Object getElementAt(int i) {
            return ((FTreeNodeSorter)this.s.get(i)).algorithmName();
        }

        public void remove(int i) {
            this.s.remove(i);
        }

        public void add(Object o) {
            this.s.add(o);
        }

        public Object get(int i) {
            return this.s.get(i);
        }

        public void move(int i, int j) {
            Object o = this.s.get(i);
            this.s.remove(i);
            this.s.add(j, o);
        }

        public ArrayList list() {
            return this.s;
        }
    }
}

