/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceLoaderGUI
extends InterfaceGeneralGUI {
    public static final Logger FCSLOG = Logger.getLogger(InterfaceLoaderGUI.class.getName());

    public long getLoGoToHandoffTimeout();

    public long getLoGoToStorageTimeout();

    public long getLoGoToEngagedTimeout();

    public long getOpenHooksTimeout();

    public long getCloseHooksTimeout();

    public long getClampHooksTimeout();

    public long getConnectLoaderTimeout();

    public long getDisconnectLoaderTimeout();

    public void setLoGoToHandoffTimeout(int var1);

    public void setLoGoToStorageTimeout(int var1);

    public void setLoGoToEngagedTimeout(int var1);

    public void setClampHooksTimeout(long var1);

    public void setCloseHooksTimeout(long var1);

    public void setOpenHooksTimeout(long var1);

    public void setConnectLoaderTimeout(long var1);

    public void setDisconnectLoaderTimeout(long var1);

    default public void loLoadFilter() {
        FCSLOG.finer(() -> "GUI: Loading filter in camera with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("loadFilter", this.getLoGoToHandoffTimeout());
    }

    default public void loUnloadFilter() {
        FCSLOG.finer(() -> "GUI: Unloading filter in camera with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("unloadFilter", this.getLoGoToHandoffTimeout());
    }

    default public void connectLoaderStandalone(String loaderIdentifier) {
        FCSLOG.fine(() -> "GUI: Connecting loader CANbus with a timeout of " + this.getConnectLoaderTimeout());
        this.sendCommand("connectLoaderStandaloneCANbus " + loaderIdentifier, this.getConnectLoaderTimeout());
    }

    default public void disconnectLoaderStandalone() {
        FCSLOG.fine(() -> "GUI: Disconnecting loader CANbus with a timeout of " + this.getDisconnectLoaderTimeout());
        this.sendCommand("disconnectLoaderStandaloneCANbus", this.getDisconnectLoaderTimeout());
    }

    default public void loLoadFilterIntoBenchOrStorageBox() {
        FCSLOG.fine(() -> "GUI: Loading filter in storage box with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("loadFilterIntoBenchOrStorageBox", this.getLoGoToHandoffTimeout());
    }

    default public void loUnloadFilterFromBenchOrStorageBox() {
        FCSLOG.fine(() -> "GUI: Unloading filter from storage box with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("unloadFilterFromBenchOrStorageBox", this.getLoGoToHandoffTimeout());
    }

    default public void loMoveFilterStoH() {
        FCSLOG.fine(() -> "GUI: Move Filter to Handoff with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("moveFilterToHandoff", this.getLoGoToHandoffTimeout(), "loader");
    }

    default public void loMoveFilterHtoS() {
        FCSLOG.fine(() -> "GUI: Move Filter to Storage with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("moveFilterToStorage", this.getLoGoToHandoffTimeout(), "loader");
    }

    default public void loMoveEmptyToHandClose() {
        FCSLOG.fine(() -> "GUI: Move Empty to Handoff and Close with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("moveEmptyToHandoffAndClose", this.getLoGoToHandoffTimeout(), "loader");
    }

    default public void loOpenClampAndMoveEmptyToS() {
        FCSLOG.fine(() -> "GUI: Open clamp and move Empty to Storage with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("openClampAndMoveEmptyToStorage", this.getLoGoToHandoffTimeout(), "loader");
    }

    default public void loGoToHandOff() {
        FCSLOG.fine(() -> "GUI: Carrier going to Handoff Position with a timeout of " + this.getLoGoToHandoffTimeout());
        this.sendCommand("goToHandOff", this.getLoGoToHandoffTimeout(), "carrier");
    }

    default public void loGoToEngaged() {
        FCSLOG.fine(() -> "GUI: Carrier going to Engaged Position with a timeout of " + this.getLoGoToEngagedTimeout());
        this.sendCommand("goToEngaged", this.getLoGoToEngagedTimeout(), "carrier");
    }

    default public void loGoToStorage() {
        FCSLOG.fine(() -> "GUI: Carrier going to Storage Position with a timeout of " + this.getLoGoToStorageTimeout());
        this.sendCommand("goToStorage", this.getLoGoToStorageTimeout(), "carrier");
    }

    default public void loUpdateCarrierPosition() {
        FCSLOG.fine(() -> "GUI: Updating carrier position with a timeout of 1000");
        this.sendCommand("updatePosition", 1000L, "carrier");
    }

    default public void loClampHooks() {
        FCSLOG.fine(() -> "GUI: Clamping Hooks with a timeout of " + this.getClampHooksTimeout());
        this.sendCommand("clamp", this.getClampHooksTimeout(), "hooks");
    }

    default public void loCloseHooks() {
        FCSLOG.fine(() -> "GUI: Closing Hooks with a timeout of " + this.getCloseHooksTimeout());
        this.sendCommand("close", this.getCloseHooksTimeout(), "hooks");
    }

    default public void loUnclampHooks() {
        FCSLOG.fine(() -> "GUI: Unclamping Hooks with a timeout of " + this.getClampHooksTimeout());
        this.sendCommand("unclamp", this.getClampHooksTimeout(), "hooks");
    }

    default public void loOpenHooks() {
        FCSLOG.fine(() -> "GUI: Opening Hooks with a timeout of " + this.getOpenHooksTimeout());
        this.sendCommand("open", this.getOpenHooksTimeout(), "hooks");
    }

    default public void loClampHoming() {
        FCSLOG.fine(() -> "GUI: Clamp homing with a timeout of " + this.getOpenHooksTimeout());
        this.sendCommand("homing", this.getOpenHooksTimeout(), "hooks");
    }

    default public void setLoSlowMode() {
        FCSLOG.fine(() -> "GUI: Loader Carrier entering slow mode with a timeout of 1000");
        this.sendCommand("setSlowMode", 1000L, "carrier");
    }

    default public void setLoFastMode() {
        FCSLOG.fine(() -> "GUI: Loader Carrier entering fast mode with a timeout of 1000");
        this.sendCommand("setFastMode", 1000L, "carrier");
    }
}

