/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import jas.hist.Rebinnable1DHistogramData;
import jas.hist.test.Gauss;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menus.IncludeInMenu;
import plotter.Axis;
import plotter.AxisModel;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DefaultAxisModel;
import plotter.DiscreteAxisModel;
import plotter.Histogram1DOverlay;
import plotter.LinLogAxisModel;
import plotter.LinearAxisModel;
import plotter.LogarithmicAxisModel;
import plotter.PlotLayout;
import plotter.TestFrame;

public class DataSourceAdapter {
    private Rebinnable1DHistogramData dataSource;
    private final DefaultAxisModel xModel;
    private final ContinuousAxisModel yModel;
    private final Histogram1DOverlay overlay;
    private LinearAxisModel linearAxisModel;
    private LogarithmicAxisModel logarithmicAxisModel;
    private int bins;

    public static void main(String[] args) {
        Gauss dataSource = new Gauss();
        final DataSourceAdapter dsa = new DataSourceAdapter(dataSource);
        Axis bottomAxis = new Axis(dsa.getXModel(), Axis.AxisPosition.BOTTOM);
        Axis leftAxis = new Axis(dsa.getYModel(), Axis.AxisPosition.LEFT);
        DataArea da = new DataArea(bottomAxis, leftAxis);
        da.add(dsa.getOverlay());
        JPanel plotPanel = new JPanel(new PlotLayout());
        plotPanel.add((Component)bottomAxis, "South");
        plotPanel.add((Component)leftAxis, "West");
        plotPanel.add((Component)da, "Center");
        final JSlider slider = new JSlider();
        slider.setMinimum(1);
        slider.setMaximum(200);
        slider.setValue(dsa.getBins());
        slider.setEnabled(dataSource.isRebinnable());
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                dsa.doRebin(slider.getValue());
            }
        });
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)plotPanel, "Center");
        topPanel.add((Component)slider, "South");
        new TestFrame("Gauss", topPanel);
    }

    DataSourceAdapter(Rebinnable1DHistogramData dataSource) {
        this.dataSource = dataSource;
        this.linearAxisModel = new LinearAxisModel(0.0, 1.0);
        this.logarithmicAxisModel = new LogarithmicAxisModel(1.0, 10.0);
        this.xModel = new DefaultAxisModel(dataSource.getMin(), dataSource.getMax(), this.bins, false, false);
        this.yModel = new LinLogAxisModel(this.linearAxisModel, this.logarithmicAxisModel);
        this.overlay = new Histogram1DOverlay("data", (DiscreteAxisModel)this.xModel, this.yModel){

            @Override
            @IncludeInMenu(value="Show Error Bars")
            public void setShowErrorBars(boolean showErrorBars) {
                super.setShowErrorBars(showErrorBars);
                DataSourceAdapter.this.doRebin(DataSourceAdapter.this.bins);
            }
        };
        this.doRebin(dataSource.getBins());
    }

    private void doRebin(int bins) {
        double[] minusError;
        double[] plusError;
        this.bins = bins;
        double min = this.dataSource.getMin();
        double max = this.dataSource.getMax();
        double[][] rebin = this.dataSource.rebin(bins, min, max, true, false);
        double[] data = rebin[0];
        if (rebin.length > 2) {
            plusError = rebin[1];
            minusError = rebin[2];
        } else if (rebin.length > 1) {
            minusError = rebin[1];
            plusError = minusError;
        } else {
            minusError = new double[data.length];
            plusError = minusError;
            for (int i = 0; i < plusError.length; ++i) {
                plusError[i] = Math.sqrt(data[i]);
            }
        }
        double yMin = Double.NaN;
        double yMinAboveZero = Double.NaN;
        double yMax = Double.NaN;
        for (int i = 0; i < bins; ++i) {
            double dataLow;
            double dataHigh = this.overlay.isShowErrorBars() ? data[i] + plusError[i] : data[i];
            double d = dataLow = this.overlay.isShowErrorBars() ? data[i] - minusError[i] : data[i];
            if (Double.isNaN(yMin)) {
                yMin = dataLow;
                yMax = dataHigh;
            } else {
                yMin = Math.min(yMin, dataLow);
                yMax = Math.max(yMax, dataHigh);
            }
            if (!(dataLow > 0.0)) continue;
            yMinAboveZero = Double.isNaN(yMinAboveZero) ? dataLow : Math.min(yMinAboveZero, dataLow);
        }
        this.linearAxisModel.setRange(yMin, yMax);
        this.logarithmicAxisModel.setRange(yMinAboveZero, yMax);
        this.xModel.setBins(min, max, bins);
        this.overlay.setData(data);
        this.overlay.setPlusErrorBars(plusError);
        this.overlay.setMinusErrorBars(minusError);
    }

    public Histogram1DOverlay getOverlay() {
        return this.overlay;
    }

    public AxisModel getXModel() {
        return this.xModel;
    }

    public ContinuousAxisModel getYModel() {
        return this.yModel;
    }

    public int getBins() {
        return this.bins;
    }
}

