/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import plotter.AbstractAxisModel;
import plotter.ContinuousAxisModel;

public class SimpleContinuousAxisModel
extends AbstractAxisModel
implements ContinuousAxisModel {
    private double min;
    private double max;

    public SimpleContinuousAxisModel(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public double getAxisCoordinateFromModelCoordinate(double param) {
        if (param < this.min || param > this.max) {
            return Double.NaN;
        }
        return (param - this.min) / (this.max - this.min);
    }

    @Override
    public double getModelCoordinateFromAxisCoordinate(double param) {
        if (param < 0.0 || param > 1.0) {
            return Double.NaN;
        }
        return this.min + param * (this.max - this.min);
    }

    public void setRange(double min, double max) {
        this.min = min;
        this.max = max;
        this.fireAxisChanged();
    }
}

