/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.text.NumberFormat;

final class AxisLabelFormatter {
    private NumberFormat formatter = NumberFormat.getInstance();
    private double power;

    AxisLabelFormatter(int power) {
        this.power = Math.pow(10.0, -power);
    }

    void setFractionDigits(int fractDigits) {
        this.formatter.setMinimumFractionDigits(fractDigits);
        this.formatter.setMaximumFractionDigits(fractDigits);
    }

    String format(double d) {
        return this.formatter.format(d * this.power);
    }

    String formatToolTip(double d) {
        int n = this.formatter.getMinimumFractionDigits();
        this.setFractionDigits(n + 2);
        String result = this.formatter.format(d);
        this.setFractionDigits(n);
        return result;
    }
}

