/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.MonitorTaskPanel;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.HexState;

public class HexControlPanel
extends JPanel
implements CommandSender.ReplyHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private MonitorTaskPanel monTaskPanel;
    private int numMonTasks = 0;
    private static final long serialVersionUID = 1L;

    public HexControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        HexState hs = (HexState)reply;
        if (this.numMonTasks > 0) {
            this.remove((Component)this.monTaskPanel);
        }
        this.monTaskPanel.initPanel(hs.getMonitorTasks());
        this.numMonTasks = hs.getNumMonTasks();
        if (this.numMonTasks > 0) {
            GridBagConstraints gbm = new GridBagConstraints();
            gbm.insets = new Insets(5, 0, 0, 0);
            gbm.anchor = 11;
            gbm.gridx = 0;
            gbm.gridy = 1;
            this.add((Component)this.monTaskPanel, gbm);
        }
        this.updatePanel(hs);
    }

    public void updatePanel(HexState hs) {
        SwingUtilities.invokeLater(new UpdateHexState(hs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.monTaskPanel = new MonitorTaskPanel("Monitor Task Control", this.sender, "MonitorControl");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.statusPanel, gbm);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            HexControlPanel.this.statusPanel.disablePanel();
            HexControlPanel.this.monTaskPanel.disablePanel();
            HexControlPanel.this.repaint();
        }
    }

    class UpdateHexState
    implements Runnable {
        private final HexState hs;

        UpdateHexState(HexState hs) {
            this.hs = hs;
        }

        @Override
        public void run() {
            HexControlPanel.this.statusPanel.updatePanel(this.hs.getTickMillis());
            HexControlPanel.this.monTaskPanel.updatePanel(this.hs.getMonitorTasks());
            HexControlPanel.this.repaint();
        }
    }
}

