/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.data.BasicState;

public class BasicMain
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    private final String agentType;
    private MonitorTaskControl monitorControl;

    public BasicMain(String agentName, String agentType) {
        super(agentName, AgentInfo.AgentType.WORKER);
        this.agentType = agentType;
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode(this, "MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("basic-state", () -> this.updateState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty(this.agentType, ((Object)((Object)this)).getClass().getCanonicalName());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state", level=0)
    public BasicState getFullState() {
        return new BasicState(this.monitorControl.getPublishPeriod());
    }

    private void updateState() {
        if (this.monitorControl.hasPeriodChanged()) {
            this.publishState();
        }
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("BasicState", (Serializable)new BasicState(this.monitorControl.getPublishPeriod())));
    }
}

