/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.datasource;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import org.freehep.application.Application;
import org.freehep.jas.services.DataSource;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.util.OpenLocalFilePanel;
import org.freehep.swing.wizard.Finishable;
import org.freehep.swing.wizard.WizardPage;

public class FileHandlerDataSource
implements DataSource {
    private String name;
    private FileHandler handler;

    public FileHandlerDataSource(FileHandler handler) {
        this(handler, null);
    }

    public FileHandlerDataSource(FileHandler handler, String name) {
        this.name = name;
        this.handler = handler;
    }

    @Override
    public String getName() {
        return this.name == null ? this.handler.getFileFilter().getDescription() : this.name;
    }

    @Override
    public WizardPage getWizardPage() {
        return new FHWizardPage();
    }

    protected void openFile(File file) throws IOException {
        this.handler.openFile(file);
    }

    protected Component addOptions() {
        return null;
    }

    private class FHWizardPage
    extends WizardPage
    implements Finishable {
        private OpenLocalFilePanel panel;

        FHWizardPage() {
            this.panel = new OpenLocalFilePanel(FileHandlerDataSource.this.handler.getClass().getName() + ".files", FileHandlerDataSource.this.handler.getFileFilter(), false, false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.anchor = 11;
            gbc.weightx = 1.0;
            this.add(this.panel, gbc);
            Component c = FileHandlerDataSource.this.addOptions();
            gbc.weighty = 1.0;
            this.add(c == null ? new JPanel() : c, gbc);
        }

        public void onFinish() {
            try {
                FileHandlerDataSource.this.openFile(new File(this.panel.getText()));
                this.panel.saveState();
                this.dispose();
            }
            catch (IOException x) {
                Application.getApplication().error("Error opening file", (Throwable)x);
            }
        }
    }
}

