/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;

public class CompositeIcon {
    private static final byte PADDING = 2;
    private static final HashMap<CompositeIcon, ImageIcon> cache = new HashMap(0);
    private final ImageIcon[] icons;

    private CompositeIcon(ImageIcon ... icons) {
        this.icons = icons;
    }

    public static ImageIcon get(ImageIcon ... icons) {
        return switch (icons.length) {
            case 0 -> null;
            case 1 -> icons[0];
            default -> {
                int nNull = 0;
                for (ImageIcon ic : icons) {
                    if (ic != null) continue;
                    ++nNull;
                }
                if (nNull > 0) {
                    yield CompositeIcon.get(Arrays.asList(icons).stream().filter(i -> i != null).toList());
                }
                CompositeIcon combo = new CompositeIcon(icons);
                ImageIcon icon = cache.get(combo);
                if (icon == null) {
                    icon = CompositeIcon.combine(icons);
                    cache.put(combo, icon);
                }
                yield icon;
            }
        };
    }

    public static ImageIcon get(List<ImageIcon> icons) {
        return switch (icons.size()) {
            case 0 -> null;
            case 1 -> icons.get(0);
            default -> CompositeIcon.get(icons.toArray(new ImageIcon[0]));
        };
    }

    private static ImageIcon combine(ImageIcon ... icons) {
        int totalWidth = (icons.length - 1) * 2;
        int minHeight = 0;
        for (int i = 0; i < icons.length; ++i) {
            totalWidth += icons[i].getIconWidth();
            if (icons[i].getIconHeight() <= minHeight) continue;
            minHeight = icons[i].getIconHeight();
        }
        BufferedImage compositeImage = new BufferedImage(totalWidth, minHeight, 2);
        Graphics2D graphics = compositeImage.createGraphics();
        int x = 0;
        for (int i = 0; i < icons.length; ++i) {
            ImageIcon icon = icons[i];
            graphics.drawImage(icon.getImage(), x, 0, null);
            x += icon.getIconWidth() + 2;
        }
        return new ImageIcon(compositeImage);
    }

    public int hashCode() {
        int hash = this.icons.length;
        for (int i = 0; i < this.icons.length; ++i) {
            hash += this.icons[i].hashCode() * (i + 1);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeIcon)) {
            return false;
        }
        CompositeIcon other = (CompositeIcon)obj;
        if (this.icons.length != other.icons.length) {
            return false;
        }
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.icons[i].hashCode() == other.icons[i].hashCode()) continue;
            return false;
        }
        return true;
    }
}

