/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.SelfDestructor;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.plugins.trending.TrendPage;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.gconsole.util.swing.InputFilteringPanel;
import org.lsst.ccs.gconsole.util.swing.MouseAdapterDoubleClick;

public class InputBlocker {
    private static final Icon[] icons = new Icon[]{new ImageIcon(InputBlocker.class.getResource("block_X_X.png"), "no panels"), new ImageIcon(InputBlocker.class.getResource("block_X_B.png"), "no selection, others blocked"), new ImageIcon(InputBlocker.class.getResource("block_X_A.png"), "no selection, others active"), new ImageIcon(InputBlocker.class.getResource("block_X_M.png"), "no selection, others mixed"), new ImageIcon(InputBlocker.class.getResource("block_B_X.png"), "selection blocked, no others"), new ImageIcon(InputBlocker.class.getResource("block_B_B.png"), "selection blocked, others blocked"), new ImageIcon(InputBlocker.class.getResource("block_B_A.png"), "selection blocked, others active"), new ImageIcon(InputBlocker.class.getResource("block_B_M.png"), "selection blocked, others mixed"), new ImageIcon(InputBlocker.class.getResource("block_A_X.png"), "selection active, no others"), new ImageIcon(InputBlocker.class.getResource("block_A_B.png"), "selection active, others blocked"), new ImageIcon(InputBlocker.class.getResource("block_A_A.png"), "selection active, others active"), new ImageIcon(InputBlocker.class.getResource("block_A_M.png"), "selection active, others mixed")};
    private static final String WRAPPER_KEY = "_InputBlocker_";
    private static JLabel label;
    private static Action blockSelected;
    private static Action enableSelected;
    private static Action blockAll;
    private static Action enableAll;
    private static boolean updateScheduled;
    private static final InputFilteringPanel.Listener filterPanelListener;

    public static void initialize() {
        ThreadUtil.invokeLater(() -> {
            label = new JLabel(icons[0]);
            Console.getConsole().insertStatusBarComponent(label, 0);
            label.setToolTipText("<html>Safe mode blocks input to data panels:<br>- click to toggle selected;<br>- double-click to toggle all.</html>");
            label.addMouseListener(new MouseAdapterDoubleClick(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseClickedFiltered(MouseEvent e) {
                    if (e.getButton() == 1) {
                        switch (e.getClickCount()) {
                            case 1: {
                                InputBlocker.toggleBlockSelected();
                                break;
                            }
                            case 2: {
                                InputBlocker.toggleBlockAll();
                            }
                        }
                    }
                }
            });
            blockSelected = new AbstractAction("Block input to selected data panel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputBlocker.setBlockSelected(true);
                }
            };
            enableSelected = new AbstractAction("Enable input to selected data panel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputBlocker.setBlockSelected(false);
                }
            };
            blockAll = new AbstractAction("Block input to all data panels"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputBlocker.setBlockAll(true);
                }
            };
            enableAll = new AbstractAction("Enable input to all data panels"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputBlocker.setBlockAll(false);
                }
            };
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(blockSelected);
            popupMenu.add(enableSelected);
            popupMenu.add(blockAll);
            popupMenu.add(enableAll);
            label.setComponentPopupMenu(popupMenu);
            Console.getConsole().getPanelManager().addListener(e -> {
                Panel key = e.getStandardKey();
                if (key == Panel.SELECTED || key == Panel.OPEN) {
                    SwingUtilities.invokeLater(() -> InputBlocker.updateLabel());
                }
            });
        });
    }

    public static JComponent wrap(JComponent content, boolean blocked) {
        Glass glass = new Glass(content);
        glass.setBlocked(blocked);
        content.putClientProperty(WRAPPER_KEY, glass);
        glass.addListener(filterPanelListener);
        return glass;
    }

    public static boolean isBlocked(Component component) {
        Glass glass = InputBlocker.getGlass(component);
        return glass == null ? false : glass.isBlocked();
    }

    public static void setBlockSelected(boolean block) {
        ThreadUtil.invokeLater(() -> {
            PanelManager panMan = Console.getConsole().getPanelManager();
            Component selectedDataPanel = panMan.getSelectedPanel(PanelType.DATA);
            if (selectedDataPanel != null) {
                InputBlocker.setBlocked(selectedDataPanel, block);
            }
        });
    }

    public static void setBlockAll(boolean block) {
        ThreadUtil.invokeLater(() -> {
            PanelManager panMan = Console.getConsole().getPanelManager();
            panMan.getPanels(Panel.TYPE, PanelType.DATA).forEach(component -> InputBlocker.setBlocked(component, block));
        });
    }

    public static void toggleBlockSelected() {
        ThreadUtil.invokeLater(() -> {
            PanelManager panMan = Console.getConsole().getPanelManager();
            Component selectedDataPanel = panMan.getSelectedPanel(PanelType.DATA);
            if (selectedDataPanel != null) {
                boolean block = InputBlocker.isBlocked(selectedDataPanel);
                InputBlocker.setBlocked(selectedDataPanel, !block);
            }
        });
    }

    public static void toggleBlockAll() {
        ThreadUtil.invokeLater(() -> {
            PanelManager panMan = Console.getConsole().getPanelManager();
            Component selectedDataPanel = panMan.getSelectedPanel(PanelType.DATA);
            List<? extends Component> dataPanels = panMan.getPanels(Panel.TYPE, PanelType.DATA);
            boolean block = selectedDataPanel == null || selectedDataPanel instanceof TrendPage ? dataPanels.stream().anyMatch(c -> InputBlocker.isBlocked(c)) : InputBlocker.isBlocked(selectedDataPanel);
            dataPanels.forEach(c -> InputBlocker.setBlocked(c, !block));
        });
    }

    private static int getState() {
        PanelManager panMan = Console.getConsole().getPanelManager();
        Component selectedDataPanel = panMan.getSelectedPanel(PanelType.DATA);
        if (selectedDataPanel instanceof TrendPage) {
            selectedDataPanel = null;
        }
        boolean hasBlocked = false;
        boolean hasActive = false;
        for (Component component : panMan.getPanels(Panel.TYPE, PanelType.DATA)) {
            if (component == selectedDataPanel || component instanceof TrendPage) continue;
            boolean blocked = InputBlocker.isBlocked(component);
            hasBlocked = hasBlocked || blocked;
            boolean bl = hasActive = hasActive || !blocked;
            if (!hasBlocked || !hasActive) continue;
            break;
        }
        int state = 4 * (selectedDataPanel == null ? 0 : (InputBlocker.isBlocked(selectedDataPanel) ? 1 : 2));
        state = hasBlocked ? (state += hasActive ? 3 : 1) : (state += hasActive ? 2 : 0);
        return state;
    }

    private static void updateLabel() {
        boolean noActivePanels;
        updateScheduled = false;
        int state = InputBlocker.getState();
        label.setIcon(icons[state]);
        blockSelected.setEnabled(state > 7);
        enableSelected.setEnabled(state > 3 && state < 8);
        blockAll.setEnabled(state == 2 || state == 3 || state > 5);
        enableAll.setEnabled(state == 1 || state > 2 && state < 8 || state == 9 || state == 11);
        boolean bl = noActivePanels = state == 0 || state == 1 || state == 4 || state == 5;
        if (state != 1 && state != 5) {
            SelfDestructor.setSafe(noActivePanels);
        }
    }

    private static Glass getGlass(Component component) {
        try {
            return (Glass)((JComponent)component).getClientProperty(WRAPPER_KEY);
        }
        catch (ClassCastException | NullPointerException x) {
            return null;
        }
    }

    private static void setBlocked(Component component, boolean blocked) {
        Glass glass = InputBlocker.getGlass(component);
        if (glass != null) {
            glass.setBlocked(blocked);
        }
    }

    static {
        filterPanelListener = e -> {
            if (!updateScheduled) {
                updateScheduled = true;
                SwingUtilities.invokeLater(InputBlocker::updateLabel);
            }
        };
    }

    private static class Glass
    extends InputFilteringPanel {
        public Glass(JComponent content) {
            super(content);
        }

        @Override
        protected void onBlock(MouseEvent e) {
            Object[] options = new Object[]{"Enable this panel", "Enable all panels", "Keep disabled"};
            int input = JOptionPane.showOptionDialog(this, "Input through this panel has been disabled to prevent accidental actions. Would you like to re-enable it?", "Safe mode", -1, 3, icons[InputBlocker.getState()], options, "Keep disabled");
            switch (input) {
                case 0: {
                    this.setBlocked(false);
                    break;
                }
                case 1: {
                    InputBlocker.setBlockAll(false);
                }
            }
        }
    }
}

