/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQDriverStats;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQFirmwareStats;
import org.lsst.ccs.daq.ims.DAQRdsStats;
import org.lsst.ccs.daq.ims.DAQRmsStats;
import org.lsst.ccs.utilities.location.Location;

public class Stats
implements AutoCloseable {
    private final String partition;
    private final long rmsClient;
    private final long rdsClient;
    private static final Logger LOG = Logger.getLogger(Stats.class.getName());

    public Stats(String partition) throws DAQException {
        this.partition = partition;
        this.rmsClient = this.attachRmsClient(partition);
        this.rdsClient = this.attachRdsClient(partition);
    }

    @Override
    public void close() throws DAQException {
        this.detachRmsClient(this.rmsClient);
        this.detachRdsClient(this.rdsClient);
    }

    public DAQRmsStats getDAQRmsStats(Location location, Clear clear) throws DAQException {
        return this.getRmsStats(this.rmsClient, location.index(), clear.getValue());
    }

    public DAQRdsStats getDAQRdsStats(Location location, Clear clear) throws DAQException {
        return this.getRdsStats(this.rdsClient, location.index(), clear.getValue());
    }

    public DAQDriverStats getDAQDriverStats(Location location, Clear clear) throws DAQException {
        return this.getDriverStats(this.rmsClient, location.index(), clear.getValue());
    }

    public DAQFirmwareStats getDAQFirmwareStats(Location location, Clear clear) throws DAQException {
        return this.getFirmwareStats(this.rmsClient, location.index(), clear.getValue());
    }

    private synchronized native long attachRmsClient(String var1) throws DAQException;

    private synchronized native long attachRdsClient(String var1) throws DAQException;

    private synchronized native void detachRmsClient(long var1) throws DAQException;

    private synchronized native void detachRdsClient(long var1) throws DAQException;

    private synchronized native DAQRmsStats getRmsStats(long var1, int var3, boolean var4) throws DAQException;

    private synchronized native DAQRdsStats getRdsStats(long var1, int var3, boolean var4) throws DAQException;

    private synchronized native DAQDriverStats getDriverStats(long var1, int var3, boolean var4) throws DAQException;

    private synchronized native DAQFirmwareStats getFirmwareStats(long var1, int var3, boolean var4) throws DAQException;

    static native String decodeException(int var0);

    static {
        System.loadLibrary("ccs_daq_ims");
    }

    public static enum Clear {
        YES(true),
        NO(false);

        private final boolean value;

        private Clear(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

