/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Component;
import javax.swing.JComponent;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.gconsole.base.OutputPane;
import org.lsst.ccs.gconsole.base.panel.DataPage;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MultistepFilter;
import org.lsst.ccs.gconsole.plugins.tracer.TracerEditor;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.util.ThreadUtil;

public class Tracer
implements Persistable {
    public static final String CATEGORY = "Tracer";
    private Panel panel;
    private volatile MessageFilter filter;
    private volatile Descriptor descriptor = new Descriptor();

    public Tracer() {
        OutputPane.Descriptor d = new OutputPane.Descriptor();
        d.setSkipLine(true);
        this.descriptor.setOut(d);
    }

    public JComponent getPanel() {
        if (this.panel == null) {
            this.panel = new Panel(this.descriptor.getOut());
        }
        return this.panel;
    }

    public MessageFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MessageFilter filter) {
        this.filter = filter;
        if (filter instanceof MultistepFilter) {
            this.descriptor.setCreator(null);
        }
    }

    public void onMessage(BusMessage message) {
        FilteredMessage before = new FilteredMessage(message);
        FilteredMessage after = this.filter.apply(before);
        if (after != null) {
            ThreadUtil.invokeLater(() -> {
                if (this.panel != null) {
                    this.panel.println(after.getText(), after.getColor());
                }
            });
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        if (this.panel == null) {
            desc.setPanel(null);
        } else {
            desc.setPanel(DataPanelDescriptor.get(this.panel));
            desc.setOut(this.panel.save());
        }
        MessageFilter f = this.filter;
        if (f instanceof MultistepFilter) {
            desc.setFilter(((MultistepFilter)f).save());
        }
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor d) {
        if (d instanceof Descriptor) {
            MultistepFilter.Descriptor fd;
            this.descriptor = ((Descriptor)d).clone();
            if (this.descriptor.getCreator() == null && (fd = this.descriptor.getFilter()) != null) {
                this.descriptor.setFilter(null);
                this.filter = new MultistepFilter(fd);
            }
        }
    }

    @Override
    public Tracer edit(String title, Component parent) {
        return TracerEditor.edit(this, parent);
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private DataPanelDescriptor panel;
        private OutputPane.Descriptor out;
        private MultistepFilter.Descriptor filter;

        @Override
        public void setCategory(String category) {
        }

        @Override
        public String getCategory() {
            return Tracer.CATEGORY;
        }

        public MultistepFilter.Descriptor getFilter() {
            return this.filter;
        }

        public void setFilter(MultistepFilter.Descriptor filter) {
            this.filter = filter;
        }

        public OutputPane.Descriptor getOut() {
            return this.out;
        }

        public void setOut(OutputPane.Descriptor out) {
            this.out = out;
        }

        public DataPanelDescriptor getPanel() {
            return this.panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (this.panel != null) {
                desc.panel = this.panel.clone();
            }
            if (this.out != null) {
                desc.out = this.out.clone();
            }
            if (this.filter != null) {
                desc.filter = this.filter.clone();
            }
            return desc;
        }
    }

    private static final class Panel
    extends OutputPane
    implements DataPage {
        Panel() {
        }

        Panel(OutputPane.Descriptor desc) {
            super(desc);
        }
    }
}

