/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.util.EnumSet;
import org.lsst.ccs.bus.messages.BusMessage;

public class FilteredMessage {
    private final BusMessage message;
    private String text;
    private EnumSet<Flag> flags;
    private Color color;

    public FilteredMessage(BusMessage busMessage) {
        this.message = busMessage;
    }

    public FilteredMessage(FilteredMessage filteredMessage) {
        this.message = filteredMessage.message;
        this.text = filteredMessage.text;
        EnumSet<Flag> as = filteredMessage.flags;
        this.flags = as == null || as.isEmpty() ? null : EnumSet.copyOf(as);
        this.color = filteredMessage.color;
    }

    public BusMessage getMessage() {
        return this.message;
    }

    public String getText() {
        return this.text == null ? this.message.toString() : this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public void addFlag(Flag action) {
        if (this.flags == null) {
            this.flags = EnumSet.of(action);
        } else {
            this.flags.add(action);
        }
    }

    public void clearFlags() {
        this.flags = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static enum Flag {
        SLEEP,
        W\u0410\u041a\u0415,
        PAUSE,
        RESUME,
        ATTENTION,
        WARNING,
        ALARM,
        CLEAR,
        LOCAL_WARNING,
        LOCAL_ALARM,
        LOCAL_CLEAR,
        MARK;

    }
}

