/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class PlotLabel
extends JLabel {
    private static final RenderingHints antiAlias = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static final Dimension minimumSize = new Dimension(1, 1);

    public PlotLabel(String text) {
        super(text);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setBorder(BorderFactory.createLineBorder(Color.RED, 5));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PlotLabel test");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new PlotLabel("<html>Test<br><i>me</i> &#956;!"));
        frame.getToolkit().setDynamicLayout(true);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension d = this.getPreferredSize();
        float width = this.getWidth();
        float height = this.getHeight();
        float scalex = width / (float)d.width;
        float scaley = height / (float)d.height;
        float scale = Math.min(scalex, scaley);
        Graphics2D newG = (Graphics2D)g.create();
        newG.translate(0.0, height * (1.0f - scale) / 2.0f);
        newG.transform(AffineTransform.getScaleInstance(scale, scale));
        newG.addRenderingHints(antiAlias);
        super.paintComponent(newG);
    }

    @Override
    public Dimension getMinimumSize() {
        return minimumSize;
    }
}

