/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.datasource;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.DataSource;
import org.freehep.jas.services.DataSourceWithoutWizard;
import org.freehep.swing.wizard.WizardDialog;
import org.freehep.swing.wizard.WizardPage;
import org.openide.util.Lookup;

class DataSourceMenu
extends JMenu {
    private final Studio _app;

    DataSourceMenu(Studio app) {
        super("Open Data Source");
        this._app = app;
        Lookup.Template template = new Lookup.Template(DataSource.class);
        Lookup.Result result = app.getLookup().lookup(template);
        ArrayList<DataSourceMenuItem> dataSources = new ArrayList<DataSourceMenuItem>();
        for (Object o : result.allInstances()) {
            dataSources.add(new DataSourceMenuItem((DataSource)o));
        }
        template = new Lookup.Template(DataSourceWithoutWizard.class);
        result = app.getLookup().lookup(template);
        for (Object o : result.allInstances()) {
            dataSources.add(new DataSourceMenuItem((DataSourceWithoutWizard)o));
        }
        Collections.sort(dataSources);
        for (DataSourceMenuItem item : dataSources) {
            this.add(item);
        }
    }

    private class AppWizardDialog
    extends WizardDialog {
        AppWizardDialog(Frame frame, String title, WizardPage firstPage) {
            super(frame, title, firstPage);
        }

        protected void handleError(String message, Throwable t) {
            DataSourceMenu.this._app.error(message, t);
        }
    }

    private class DataSourceMenuItem
    extends JMenuItem
    implements Comparable<JMenuItem> {
        private final Object _dataSource;

        DataSourceMenuItem(DataSource dataSource) {
            this._dataSource = dataSource;
            this.setText(dataSource.getName() + " ...");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)DataSourceMenu.this._app);
                    AppWizardDialog wizard = new AppWizardDialog(frame, "Open Data Source", ((DataSource)DataSourceMenuItem.this._dataSource).getWizardPage());
                    wizard.pack();
                    wizard.setLocationRelativeTo((Component)DataSourceMenu.this._app);
                    wizard.setVisible(true);
                }
            });
        }

        DataSourceMenuItem(DataSourceWithoutWizard dataSource) {
            this._dataSource = dataSource;
            this.setText(dataSource.getName());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DataSourceWithoutWizard)DataSourceMenuItem.this._dataSource).openDataSource();
                }
            });
        }

        @Override
        public int compareTo(JMenuItem other) {
            return this.getText().compareTo(other.getText());
        }
    }
}

