/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnalogInputPanel
extends JPanel {
    private final List<JLabel> values;
    private final List<JLabel> descriptions;
    private final List<String> formats;
    private JLabel description1;
    private JLabel description2;
    private JLabel description3;
    private JLabel description4;
    private JLabel jLabel1;
    private JLabel value1;
    private JLabel value2;
    private JLabel value3;
    private JLabel value4;

    public AnalogInputPanel() {
        this.initComponents();
        this.values = Collections.unmodifiableList(Arrays.asList(this.value1, this.value2, this.value3, this.value4));
        this.descriptions = Collections.unmodifiableList(Arrays.asList(this.description1, this.description2, this.description3, this.description4));
        this.formats = new ArrayList<String>();
    }

    public void configure(PlatformConfig config) {
        List<String> desc = config.getAnalogInputDescriptions();
        this.formats.clear();
        for (int i = 0; i < this.values.size(); ++i) {
            if (i < desc.size()) {
                String[] fields = desc.get(i).split("\\|", 2);
                this.formats.add(fields[1]);
                this.descriptions.get(i).setText(fields[0]);
                this.values.get(i).setText("");
                continue;
            }
            this.values.get(i).setText("");
            this.descriptions.get(i).setText("");
        }
    }

    public void update(IOStatus status) {
        List<Double> vals = status.getAnalogInputs();
        for (int i = 0; i < this.formats.size(); ++i) {
            String display = String.format(this.formats.get(i), vals.get(i));
            this.values.get(i).setText(display);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.value1 = new JLabel();
        this.value2 = new JLabel();
        this.value3 = new JLabel();
        this.value4 = new JLabel();
        this.description1 = new JLabel();
        this.description2 = new JLabel();
        this.description3 = new JLabel();
        this.description4 = new JLabel();
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.jLabel1.text"));
        this.value1.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.value1, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.value1.text"));
        this.value2.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.value2, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.value2.text"));
        this.value3.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.value3, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.value3.text"));
        this.value4.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.value4, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.value4.text"));
        Mnemonics.setLocalizedText((JLabel)this.description1, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.description1.text"));
        Mnemonics.setLocalizedText((JLabel)this.description2, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.description2.text"));
        Mnemonics.setLocalizedText((JLabel)this.description3, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.description3.text"));
        Mnemonics.setLocalizedText((JLabel)this.description4, (String)NbBundle.getMessage(AnalogInputPanel.class, (String)"AnalogInputPanel.description4.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 333, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.value4, -1, 76, Short.MAX_VALUE).addComponent(this.value3, -1, -1, Short.MAX_VALUE).addComponent(this.value2, -1, -1, Short.MAX_VALUE).addComponent(this.value1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.description1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.description2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.description3, -1, -1, Short.MAX_VALUE).addComponent(this.description4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.value1).addComponent(this.description1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.value2).addComponent(this.description2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.value3).addComponent(this.description3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.value4).addComponent(this.description4)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

