/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.LoggerHelper;
import nom.tam.util.RandomAccess;

public abstract class Data
implements FitsElement {
    private static final Logger LOG = LoggerHelper.getLogger(Data.class);
    private static final int FITS_BLOCK_SIZE_MINUS_ONE = 2879;
    protected long fileOffset = -1L;
    protected long dataSize;
    protected RandomAccess input;

    abstract void fillHeader(Header var1) throws FitsException;

    public abstract Object getData() throws FitsException;

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public Object getKernel() throws FitsException {
        return this.getData();
    }

    @Override
    public long getSize() {
        return FitsUtil.addPadding(this.getTrueSize());
    }

    abstract long getTrueSize();

    @Override
    public abstract void read(ArrayDataInput var1) throws FitsException;

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to reset", e);
            return false;
        }
    }

    @Override
    public void rewrite() throws FitsException {
        if (!this.rewriteable()) {
            throw new FitsException("Illegal attempt to rewrite data");
        }
        FitsUtil.reposition(this.input, this.fileOffset);
        this.write((ArrayDataOutput)((Object)this.input));
        try {
            ((ArrayDataOutput)((Object)this.input)).flush();
        }
        catch (IOException e) {
            throw new FitsException("Error in rewrite flush: " + e);
        }
    }

    @Override
    public boolean rewriteable() {
        return this.input != null && this.fileOffset >= 0L && (this.getTrueSize() + 2879L) / 2880L == (this.dataSize + 2879L) / 2880L;
    }

    protected void setFileOffset(ArrayDataInput o) {
        if (o instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(o);
            this.dataSize = this.getTrueSize();
            this.input = (RandomAccess)o;
        }
    }

    @Override
    public abstract void write(ArrayDataOutput var1) throws FitsException;
}

