/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.ccob.CCOBSim;
import org.lsst.ccs.drivers.ccob.CCOBSocketDriver;
import org.lsst.ccs.drivers.ccob.CCOBUsb;
import org.lsst.ccs.drivers.ccob.jni.CcobJNI;
import org.lsst.ccs.shell.JLineShell;

public class TestCcob {
    private static final PrintStream out = System.out;

    public static void main(String[] args) throws IOException {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            if (!optns.showHelp) {
                out.println(e.getMessage());
            }
            TestCcob.showHelp(parser);
            System.exit(0);
        }
        if (optns.showHelp) {
            TestCcob.showHelp(parser);
            System.exit(0);
        }
        CCOBInterface ccob = null;
        switch (optns.type) {
            case USB: {
                ccob = new CCOBUsb(optns.index);
                break;
            }
            case SOCKET: {
                ccob = new CCOBSocketDriver(optns.node, optns.port);
                break;
            }
            case JNI: {
                ccob = new CcobJNI();
                break;
            }
            case SIM: {
                ccob = new CCOBSim();
            }
        }
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(new CommandSetBuilder().buildCommandSet((Object)new CCOBCommands(ccob)));
        JLineShell shell = new JLineShell((CommandSet)compositeSet, ">> ");
        shell.run();
        System.exit(0);
    }

    private static void showHelp(CmdLineParser parser) {
        out.println("Usage: TestCcob [options...]");
        out.println("Options:");
        parser.printUsage((OutputStream)out);
    }

    public static enum ConnType {
        USB,
        SOCKET,
        JNI,
        SIM;

    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="Connection type: usb (default), socket, jni or sim")
        private ConnType type = ConnType.USB;
        @Option(name="-i", metaVar="<index>", usage="USB device index")
        private int index = 0;
        @Option(name="-n", metaVar="<node>", usage="Node name")
        private String node = "localhost";
        @Option(name="-s", metaVar="<socket>", usage="Socket number")
        private int port = 1557;
        @Option(name="-help", usage="Displays this help")
        private boolean showHelp;

        private Options() {
        }
    }
}

