/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.DemultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.IntBufferWriter;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class Example1 {
    public static void main(String[] args) throws DAQException, IOException {
        Store store = new Store("dev");
        System.out.printf("capacity %,d\n", store.getCapacity());
        System.out.printf("remaining %,d\n", store.getRemaining());
        Catalog catalog = store.getCatalog();
        List<Folder> list = catalog.list();
        Collections.sort(list);
        for (Folder folder : list) {
            System.out.println(folder.getName());
        }
        Folder insert = catalog.insert("test3");
        list = catalog.list();
        Collections.sort(list);
        for (Folder folder : list) {
            System.out.println(folder.getName());
        }
        Folder folder = catalog.find("test3");
        System.out.println(folder.equals(insert));
        catalog.remove("test3");
        list = catalog.list();
        Collections.sort(list);
        for (Folder folder4 : list) {
            System.out.println(folder4.getName());
        }
        Folder folder2 = catalog.find("emu");
        List<Image> images = folder2.listImages();
        Collections.sort(images);
        images.forEach(image -> System.out.println(image.getMetaData()));
        Image image2 = images.get(0);
        List<Source> sources = image2.listSources();
        Collections.sort(sources);
        long totalSize = 0L;
        for (Source source : sources) {
            System.out.println(source.getMetaData());
            totalSize += source.size();
        }
        System.out.printf("Expected size %,d bytes\n", totalSize);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1000000);
        long totalReadSize = 0L;
        long start = System.nanoTime();
        block22: for (Source source : sources) {
            ByteChannel channel = source.openChannel(Source.ChannelMode.READ);
            Throwable throwable = null;
            try {
                while (true) {
                    buffer.clear();
                    int l = channel.read(buffer);
                    if (l < 0) continue block22;
                    totalReadSize += (long)l;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (channel == null) continue;
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                channel.close();
            }
        }
        long stop = System.nanoTime();
        System.out.printf("Read %,d bytes in %,dns (%d MBytes/second)\n", totalReadSize, stop - start, 1000L * totalReadSize / (stop - start));
        boolean i = false;
        long unpackSize = 0L;
        start = System.nanoTime();
        for (Source source : sources) {
            ByteChannel channel = source.openChannel(Source.ChannelMode.READ);
            Throwable throwable = null;
            try {
                int rebs = source.getMetaData().getSensor().getCCDCount();
                int outputSize = (int)source.getMetaData().getLength() / 9 * 16 / rebs / 4;
                WritableIntChannel[] output = new IntBufferWriter[16 * rebs];
                for (int j = 0; j < output.length; ++j) {
                    output[j] = new IntBufferWriter(IntBuffer.allocate(outputSize));
                }
                DemultiplexingIntChannel destination = new DemultiplexingIntChannel(output);
                Decompress18BitChannel b18 = new Decompress18BitChannel(destination);
                while (true) {
                    buffer.clear();
                    int l = channel.read(buffer);
                    if (l < 0) break;
                    totalReadSize += (long)l;
                    buffer.flip();
                    b18.write(buffer.asIntBuffer());
                }
                for (WritableIntChannel output1 : output) {
                    unpackSize += (long)(4 * ((IntBufferWriter)output1).getIntBuffer().position());
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (channel == null) continue;
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                channel.close();
            }
        }
        stop = System.nanoTime();
        System.out.printf("Unpack %,d bytes in %,dns (%d MBytes/second)\n", unpackSize, stop - start, 1000L * unpackSize / (stop - start));
    }
}

